/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.base.befunde.xchange.XChangeContributor;
import ch.elexis.data.Konsultation;
import ch.elexis.icpc.fire.model.FireConfig;
import ch.elexis.icpc.fire.model.TVital;
import java.util.HashMap;
import java.util.Optional;

public class VitalSignsBuilder {
    private FireConfig config;
    private XChangeContributor xc;
    private Konsultation consultation;

    public VitalSignsBuilder(FireConfig config) {
        this.config = config;
        this.xc = new XChangeContributor();
    }

    public Optional<TVital> build() {
        if (this.consultation != null) {
            this.xc.setPatient(this.consultation.getFall().getPatient());
            TVital ret = this.config.getFactory().createTVital();
            Optional<Float> bauchumfang = this.getBauchumfang();
            Optional<Integer> bpDiast = this.getBpDiast();
            Optional<Integer> bpSyst = this.getBpSyst();
            Optional<Float> gewicht = this.getGewicht();
            Optional<Float> groesse = this.getGroesse();
            Optional<Integer> puls = this.getPuls();
            if (bauchumfang.isPresent() || bpDiast.isPresent() || bpSyst.isPresent() || gewicht.isPresent() || groesse.isPresent() || puls.isPresent()) {
                bauchumfang.ifPresent(value -> ret.setBauchumfang((Float)value));
                bpDiast.ifPresent(value -> ret.setBpDiast((Integer)value));
                bpSyst.ifPresent(value -> ret.setBpSyst((Integer)value));
                gewicht.ifPresent(value -> ret.setGewicht((Float)value));
                groesse.ifPresent(value -> ret.setGroesse((Float)value));
                puls.ifPresent(value -> ret.setPuls((Integer)value));
                return Optional.of(ret);
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> getBpDiast() {
        Optional<String> value = this.useCombinedBdValue() ? this.getBdVitalParm(BDIdentifier.DIAST) : this.getVitalParm(this.config.getBdDiastTab());
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.parseInt(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> getBpSyst() {
        Optional<String> value = this.useCombinedBdValue() ? this.getBdVitalParm(BDIdentifier.SYST) : this.getVitalParm(this.config.getBdSystTab());
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.parseInt(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private boolean useCombinedBdValue() {
        if (this.config.getBdDiastTab() != null) {
            return this.config.getBdDiastTab().equalsIgnoreCase(this.config.getBdSystTab());
        }
        return false;
    }

    private Optional<String> getBdVitalParm(BDIdentifier identifier) {
        String[] split = this.config.getBdSystTab().split("\\s*\\:\\s*");
        String bdsyst = null;
        String bddiast = null;
        if (split.length > 1) {
            HashMap vals = this.xc.getResult(split[0].trim(), this.consultation.getDatum());
            if (this.config.getBdSystTab().equals(this.config.getBdDiastTab())) {
                String[] bds;
                String bd = (String)vals.get(split[1].trim());
                if (bd != null && (bds = bd.split("\\s*\\/\\s*")).length > 1) {
                    bdsyst = bds[0].trim();
                    bddiast = bds[1].trim();
                }
            } else {
                bdsyst = (String)vals.get(split[1].trim());
                split = this.config.getBdDiastTab().split("\\s:\\s");
                if (split.length > 1) {
                    vals = this.xc.getResult(split[0].trim(), this.consultation.getDatum());
                    bddiast = ((String)vals.get(split[1])).trim();
                }
            }
            if (identifier == BDIdentifier.DIAST) {
                return Optional.ofNullable(bddiast);
            }
            if (identifier == BDIdentifier.SYST) {
                return Optional.ofNullable(bdsyst);
            }
        }
        return Optional.empty();
    }

    private Optional<Float> getBauchumfang() {
        Optional<String> value = this.getVitalParm(this.config.getWaistTab());
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(Float.parseFloat(value.get())));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<Float> getGewicht() {
        Optional<String> value = this.getVitalParm(this.config.getWeightTab());
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(Float.parseFloat(value.get())));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<Float> getGroesse() {
        Optional<String> value = this.getVitalParm(this.config.getHeightTab());
        if (value.isPresent()) {
            try {
                return Optional.of(Float.valueOf(Float.parseFloat(value.get())));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> getPuls() {
        Optional<String> value = this.getVitalParm(this.config.getPulseTab());
        if (value.isPresent()) {
            try {
                return Optional.of(Integer.parseInt(value.get()));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<String> getVitalParm(String parameter) {
        HashMap vals;
        String[] split = parameter.split("\\s*\\:\\s*");
        if (split.length > 1 && (vals = this.xc.getResult(split[0].trim(), this.consultation.getDatum())) != null && !vals.isEmpty()) {
            return Optional.ofNullable((String)vals.get(split[1].trim()));
        }
        return Optional.empty();
    }

    public VitalSignsBuilder consultation(Konsultation consultation) {
        this.consultation = consultation;
        return this;
    }

    private static enum BDIdentifier {
        DIAST,
        SYST;

    }
}

