/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.types.Gender;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import ch.elexis.icpc.fire.model.ConsultationBuilder;
import ch.elexis.icpc.fire.model.FireConfig;
import ch.elexis.icpc.fire.model.Report;
import ch.elexis.icpc.fire.model.TConsultation;
import ch.elexis.icpc.fire.model.TDoctor;
import ch.elexis.icpc.fire.model.TMedi;
import ch.elexis.icpc.fire.model.TPatient;
import ch.elexis.icpc.fire.model.TStatus;
import ch.elexis.icpc.fire.model.XmlUtil;
import ch.rgw.tools.TimeTool;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import org.slf4j.LoggerFactory;

public class ReportBuilder {
    private Report report;
    private Map<BigInteger, TPatient> patients = new HashMap<BigInteger, TPatient>();
    private Map<BigInteger, TDoctor> doctors = new HashMap<BigInteger, TDoctor>();
    private ConsultationBuilder consultationBuilder;
    private FireConfig fireConfig = new FireConfig();

    public ReportBuilder() throws DatatypeConfigurationException {
        if (this.fireConfig.isValid()) {
            this.consultationBuilder = new ConsultationBuilder(this.fireConfig);
        }
        this.report = this.fireConfig.getFactory().createReport();
        this.report.setExportDate(XmlUtil.getXmlGregorianCalendar(new TimeTool()));
    }

    public FireConfig getFireConfig() {
        return this.fireConfig;
    }

    public void addKonsultation(BigInteger patId, BigInteger docId, Konsultation konsultation, Map<String, Set<TMedi>> unreferencedStoppedMedis) throws DatatypeConfigurationException {
        if (this.fireConfig.isValid()) {
            if (this.report.getConsultations() == null) {
                this.report.setConsultations(this.fireConfig.getFactory().createReportConsultations());
            }
            Optional<TConsultation> consultation = this.consultationBuilder.consultation(konsultation).build(unreferencedStoppedMedis);
            consultation.ifPresent(c -> {
                boolean bl = this.report.getConsultations().getConsultation().add((TConsultation)c);
            });
            consultation.ifPresent(c -> c.setDocId(docId));
            consultation.ifPresent(c -> c.setPatId(patId));
            consultation.ifPresent(c -> {
                try {
                    c.setDate(XmlUtil.getXmlGregorianCalendar(new TimeTool(konsultation.getDatum())));
                }
                catch (DatatypeConfigurationException e) {
                    LoggerFactory.getLogger(ReportBuilder.class).warn("date error", (Throwable)e);
                }
            });
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Invalid fireConfig, skipping consultation [" + konsultation.getId() + "]");
        }
    }

    public BigInteger addPatient(Patient patient) {
        BigInteger patId = this.fireConfig.getPatId(patient);
        if (this.patients.get(patId) == null) {
            if (this.report.getPatients() == null) {
                this.report.setPatients(this.fireConfig.getFactory().createReportPatients());
            }
            TPatient tPatient = this.fireConfig.getFactory().createTPatient();
            tPatient.setId(patId);
            Gender gender = patient.getGender();
            if (gender == Gender.MALE) {
                tPatient.setGender(true);
            } else if (gender == Gender.FEMALE) {
                tPatient.setGender(false);
            }
            String dateOfBirth = patient.getGeburtsdatum();
            if (dateOfBirth != null && !dateOfBirth.isEmpty()) {
                TimeTool dob = new TimeTool(dateOfBirth);
                tPatient.setBirthYear(dob.get(1));
            }
            TStatus tStatus = this.createPatientTStatus(patient);
            tPatient.setStatus(tStatus);
            this.report.getPatients().getPatient().add(tPatient);
            this.patients.put(patId, tPatient);
        }
        return patId;
    }

    private TStatus createPatientTStatus(Patient patient) {
        String insurer = null;
        Boolean mc = null;
        Query qbe = new Query(Fall.class, "PatientID", patient.getId());
        qbe.add("Gesetz", "=", "KVG");
        qbe.orderBy(true, new String[]{"DatumVon"});
        List qre = qbe.execute();
        for (Fall fall : qre) {
            Kontakt costBearer;
            if (!fall.isOpen()) continue;
            String kostentraeger = (String)fall.getInfoElement("Kostentr\u00e4ger");
            if (kostentraeger == null) {
                kostentraeger = fall.get("Kostentraeger");
            }
            if (kostentraeger == null || kostentraeger.equals(patient.getId()) || !(costBearer = Kontakt.load((String)kostentraeger)).isValid() || !costBearer.istOrganisation()) continue;
            insurer = costBearer.getLabel();
            break;
        }
        List stickers = patient.getStickers();
        for (ISticker iSticker : stickers) {
            String stickerId = ((Sticker)iSticker).getId();
            if (!CoreHub.globalCfg.get("icpc/fire/isHamSticker/" + stickerId, false)) continue;
            mc = true;
            break;
        }
        if (insurer != null || mc != null) {
            TStatus tStatus = this.fireConfig.getFactory().createTStatus();
            tStatus.setInsurer(insurer);
            tStatus.setMc(mc);
            return tStatus;
        }
        return null;
    }

    public BigInteger addMandant(Mandant mandant) {
        BigInteger docId = this.fireConfig.getDocId(mandant);
        if (this.doctors.get(docId) == null) {
            if (this.report.getDoctors() == null) {
                this.report.setDoctors(this.fireConfig.getFactory().createReportDoctors());
            }
            TDoctor tDoctor = this.fireConfig.getFactory().createTDoctor();
            tDoctor.setId(docId);
            tDoctor.setSystem("Elexis");
            tDoctor.setFirstName(mandant.getVorname());
            tDoctor.setLastName(mandant.getName());
            try {
                tDoctor.setGeburtstag(XmlUtil.getXmlGregorianCalendar(new TimeTool(mandant.getGeburtsdatum())));
            }
            catch (DatatypeConfigurationException e) {
                LoggerFactory.getLogger(ReportBuilder.class).warn("date error", (Throwable)e);
            }
            this.report.getDoctors().getDoctor().add(tDoctor);
            this.doctors.put(docId, tDoctor);
        }
        return docId;
    }

    public boolean isValidConfig() {
        return this.fireConfig.isValid();
    }

    public Optional<Report> build() {
        return Optional.ofNullable(this.report);
    }

    public void finish(Map<String, Set<TMedi>> unreferencedStopMedisPerPatient) {
        this.consultationBuilder.handleUnreferencedStopMedisPerPatient(this.fireConfig, this.report, unreferencedStopMedisPerPatient);
    }
}

