/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.icpc.fire.model.FireConfig;
import ch.elexis.icpc.fire.model.TConsultation;
import ch.elexis.icpc.fire.model.TMedi;
import ch.elexis.icpc.fire.model.XmlUtil;
import ch.rgw.tools.TimeTool;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import org.slf4j.LoggerFactory;

public class MedisBuilder {
    private Konsultation consultation;
    private FireConfig config;

    public MedisBuilder(FireConfig config) {
        this.config = config;
    }

    public MedisBuilder consultation(Konsultation consultation) {
        this.consultation = consultation;
        return this;
    }

    @Nullable
    public static TMedi createTMedi(Prescription prescription, FireConfig config) throws DatatypeConfigurationException {
        Artikel article = prescription.getArtikel();
        if (article != null) {
            String stopReason;
            ArrayList floatDosis;
            String gtin;
            String pharmacode;
            String atcCode;
            TMedi tMedi = config.getFactory().createTMedi();
            tMedi.setId(prescription.getId());
            String beginDateString = prescription.getBeginDate();
            if (beginDateString != null && !beginDateString.isEmpty()) {
                tMedi.setBeginDate(XmlUtil.getXmlGregorianCalendar(new TimeTool(beginDateString)));
            }
            if ((atcCode = article.getATC_code()) != null && !atcCode.isEmpty()) {
                tMedi.setAtc(atcCode);
            }
            if ((pharmacode = article.getPharmaCode()) != null && !pharmacode.isEmpty()) {
                try {
                    long numericPharmacode = Long.valueOf(pharmacode);
                    tMedi.setPharmacode(numericPharmacode);
                }
                catch (NumberFormatException numericPharmacode) {
                    // empty catch block
                }
            }
            if ((gtin = article.getGTIN()) != null && !gtin.isEmpty()) {
                try {
                    long gtinL = Long.valueOf(gtin);
                    tMedi.setGTIN(BigInteger.valueOf(gtinL));
                }
                catch (NumberFormatException e) {
                    LoggerFactory.getLogger(MedisBuilder.class).warn("no numeric gtin found", (Throwable)e);
                }
            }
            if ((floatDosis = Prescription.getDoseAsFloats((String)prescription.getDosis())) != null) {
                int size = floatDosis.size();
                if (size > 0) {
                    tMedi.setDosisMo((Float)floatDosis.get(0));
                }
                if (size > 1) {
                    tMedi.setDosisMi((Float)floatDosis.get(1));
                }
                if (size > 2) {
                    tMedi.setDosisAb((Float)floatDosis.get(2));
                }
                if (size > 3) {
                    tMedi.setDosisNa((Float)floatDosis.get(3));
                }
            }
            if ((stopReason = prescription.getStopReason()) != null && !stopReason.isEmpty()) {
                tMedi.setStopGrund((short)99);
            } else {
                tMedi.setStopGrund((short)0);
            }
            tMedi.setMediDauer(MedisBuilder.getType(prescription.getEntryType()));
            String stopDateString = prescription.getEndDate();
            if (stopDateString != null && !stopDateString.isEmpty()) {
                tMedi.setEndDate(XmlUtil.getXmlGregorianCalendar(new TimeTool(stopDateString)));
            }
            return tMedi;
        }
        return null;
    }

    public Optional<TConsultation.Medis> build(Map<String, Set<TMedi>> unreferencedStopMedisPerPatient) throws DatatypeConfigurationException {
        Patient patient = this.consultation.getFall().getPatient();
        Query query = new Query(Prescription.class);
        query.add("PatientID", "=", patient.getId());
        TimeTool consTime = new TimeTool(this.consultation.getDatum());
        query.add("DateFrom", "LIKE", String.valueOf(consTime.toString(9)) + "%");
        List prescriptions = query.execute();
        Set<TMedi> unreferencedStoppedMedis = unreferencedStopMedisPerPatient.get(patient.getId());
        if (unreferencedStoppedMedis != null) {
            Iterator<TMedi> iterator = unreferencedStoppedMedis.iterator();
            while (iterator.hasNext()) {
                TMedi tMedi = iterator.next();
                if (!tMedi.getEndDate().toString().startsWith(new TimeTool(consTime).toString(6))) continue;
                prescriptions.add(Prescription.load((String)tMedi.getId()));
                iterator.remove();
            }
        }
        if (prescriptions != null && !prescriptions.isEmpty()) {
            TConsultation.Medis medis = this.config.getFactory().createTConsultationMedis();
            for (Prescription prescription : prescriptions) {
                Artikel article = prescription.getArtikel();
                if (article == null) continue;
                TMedi tMedi = MedisBuilder.createTMedi(prescription, this.config);
                tMedi.setConsultation(this.consultation);
                String stopDateString = prescription.getEndDate();
                if (stopDateString != null && !stopDateString.isEmpty()) {
                    tMedi.setEndDate(XmlUtil.getXmlGregorianCalendar(new TimeTool(stopDateString)));
                    if (!stopDateString.startsWith(this.consultation.getDatum())) {
                        if (unreferencedStoppedMedis == null) {
                            unreferencedStoppedMedis = new HashSet<TMedi>();
                            unreferencedStopMedisPerPatient.put(patient.getId(), unreferencedStoppedMedis);
                        }
                        unreferencedStoppedMedis.add(tMedi);
                    }
                }
                medis.getMedi().add(tMedi);
            }
            if (!medis.getMedi().isEmpty()) {
                return Optional.of(medis);
            }
        }
        return Optional.empty();
    }

    private static String getType(EntryType entryType) {
        switch (entryType) {
            case FIXED_MEDICATION: {
                return "Fix";
            }
            case RESERVE_MEDICATION: {
                return "Reserve";
            }
            case SYMPTOMATIC_MEDICATION: {
                return "Symptom";
            }
        }
        return "";
    }
}

