/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.Konsultation;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.icpc.fire.model.FireConfig;
import ch.elexis.icpc.fire.model.TConsultation;
import ch.elexis.icpc.fire.model.TLabor;
import ch.elexis.icpc.fire.model.XmlUtil;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;

public class LaborsBuilder {
    private Konsultation consultation;
    private FireConfig config;

    public LaborsBuilder(FireConfig config) {
        this.config = config;
    }

    public LaborsBuilder consultation(Konsultation consultation) {
        this.consultation = consultation;
        return this;
    }

    public Optional<TConsultation.Labors> build() throws DatatypeConfigurationException {
        Patient patient = this.consultation.getFall().getPatient();
        TimeTool ttDate = new TimeTool(this.consultation.getDatum());
        String dayString = ttDate.toString(9);
        Query query = new Query(LabResult.class);
        query.add("PatientID", "=", patient.getId());
        query.startGroup();
        query.add("Datum", "=", dayString);
        query.or();
        query.add("observationtime", "LIKE", String.valueOf(dayString) + "%");
        query.endGroup();
        List results = query.execute();
        if (results != null && !results.isEmpty()) {
            TConsultation.Labors labors = this.config.getFactory().createTConsultationLabors();
            for (LabResult labResult : results) {
                String[] rx;
                ILabItem labItem = labResult.getItem();
                LabItemTyp labItemTyp = labItem.getTyp();
                if (labItemTyp != LabItemTyp.NUMERIC && labItemTyp != LabItemTyp.ABSOLUTE && labItemTyp != LabItemTyp.TEXT) continue;
                TLabor tLabor = this.config.getFactory().createTLabor();
                tLabor.setAnalyse(labItem.getName());
                tLabor.setAnalyseKurz(labItem.getKuerzel());
                String ref = this.getRefString(labResult, patient.getGender());
                if (ref != null && (rx = ref.split("\\s*\\-\\s*")).length > 1) {
                    Float min = this.toFloat(rx[0]);
                    Float max = this.toFloat(rx[1]);
                    if (min != null) {
                        tLabor.setMin(min);
                    }
                    if (max != null) {
                        tLabor.setMax(max);
                    }
                }
                tLabor.setEinheit(labResult.getUnit());
                tLabor.setWert(labResult.getResult());
                tLabor.setDate(XmlUtil.getXmlGregorianCalendar(this.getLabResultTime(labResult)));
                labors.getLabor().add(tLabor);
            }
            if (!labors.getLabor().isEmpty()) {
                return Optional.of(labors);
            }
        }
        return Optional.empty();
    }

    private TimeTool getLabResultTime(LabResult labResult) {
        TimeTool time = labResult.getObservationTime();
        if (time == null) {
            time = new TimeTool(labResult.getDate());
        }
        return time;
    }

    private Float toFloat(String string) {
        string = string.trim().replaceAll(",", ".");
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String getRefString(LabResult labResult, Gender gender) {
        if (gender == Gender.FEMALE) {
            return labResult.getRefFemale();
        }
        if (gender == Gender.MALE) {
            return labResult.getRefMale();
        }
        return null;
    }
}

