/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Xid;
import ch.elexis.icpc.fire.model.ObjectFactory;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireConfig {
    public static String XID_FIRE_PATID = "http://elexis.ch/icpc/fire/patid";
    private String bdSystTab;
    private String bdDiastTab;
    private String pulseTab;
    private String heightTab;
    private String weightTab;
    private String waistTab;
    private ObjectFactory factory;
    protected Logger log = LoggerFactory.getLogger(FireConfig.class);

    public FireConfig() {
        this.factory = new ObjectFactory();
        Xid.localRegisterXIDDomainIfNotExists((String)XID_FIRE_PATID, (String)"IcpcFirePatId", (int)1);
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger getPatId(Patient patient) {
        block5: {
            patientNr = patient.getPatCode();
            try {
                parseLong = Long.parseLong(patientNr);
                return BigInteger.valueOf(parseLong);
            }
            catch (NumberFormatException nfe) {
                this.log.warn("Error parsing patientNr [{}], falling back to XID_FIRE_PATID", (Object)patientNr);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException nfe) {
                    // empty catch block
                }
                existingPatId = patient.getXid(FireConfig.XID_FIRE_PATID);
                if (existingPatId != null && !existingPatId.isEmpty()) break block5;
                currentMs = System.currentTimeMillis();
                patId = new BigInteger(Long.toString(currentMs));
                existingPat = Xid.findObject((String)FireConfig.XID_FIRE_PATID, (String)patId.toString());
                ** while (existingPat != null)
            }
lbl-1000:
            // 1 sources

            {
                patId.add(BigInteger.ONE);
                existingPat = Xid.findObject((String)FireConfig.XID_FIRE_PATID, (String)patId.toString());
                continue;
            }
lbl22:
            // 1 sources

            patient.addXid(FireConfig.XID_FIRE_PATID, patId.toString(), true);
            return patId;
        }
        return new BigInteger(existingPatId);
    }

    public BigInteger getDocId(Mandant mandant) throws IllegalStateException {
        String ean = mandant.getXid("www.xid.ch/id/ean");
        if (ean != null && !ean.isEmpty()) {
            return new BigInteger(ean);
        }
        throw new IllegalStateException("Mandant " + mandant.getLabel() + " has no EAN specified.");
    }

    private boolean readVitalSignsConfig() {
        this.bdSystTab = this.getOrFail("icpc/fire/field_bd_syst");
        if (this.bdSystTab != null) {
            this.bdDiastTab = this.getOrFail("icpc/fire/field_bd_diast");
            if (this.bdDiastTab != null) {
                this.pulseTab = this.getOrFail("icpc/fire/field_puls");
                if (this.pulseTab != null) {
                    this.heightTab = this.getOrFail("icpc/fire/field_groesse");
                    if (this.heightTab != null) {
                        this.weightTab = this.getOrFail("icpc/fire/field_gewicht");
                        if (this.weightTab != null) {
                            this.waistTab = this.getOrFail("icpc/fire/field_bu");
                            if (this.waistTab != null) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private String getOrFail(String prefs) {
        String ret = CoreHub.globalCfg.get(prefs, null);
        return ret;
    }

    public ObjectFactory getFactory() {
        return this.factory;
    }

    public boolean isValid() {
        return this.readVitalSignsConfig();
    }

    public String getWaistTab() {
        return this.waistTab;
    }

    public String getBdSystTab() {
        return this.bdSystTab;
    }

    public String getBdDiastTab() {
        return this.bdDiastTab;
    }

    public String getWeightTab() {
        return this.weightTab;
    }

    public String getHeightTab() {
        return this.heightTab;
    }

    public String getPulseTab() {
        return this.pulseTab;
    }
}

