/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.icpc.Encounter;
import ch.elexis.icpc.IcpcCode;
import ch.elexis.icpc.fire.model.FireConfig;
import ch.elexis.icpc.fire.model.TConsultation;
import ch.elexis.icpc.fire.model.TDiagnose;
import java.util.List;
import java.util.Optional;

public class DiagnosesBuilder {
    private Konsultation consultation;
    private FireConfig config;

    public DiagnosesBuilder(FireConfig config) {
        this.config = config;
    }

    public DiagnosesBuilder consultation(Konsultation consultation) {
        this.consultation = consultation;
        return this;
    }

    public Optional<TConsultation.Diagnoses> build() {
        Query qbe = new Query(Encounter.class);
        qbe.add("KonsID", "=", this.consultation.getId());
        List encounters = qbe.execute();
        if (!encounters.isEmpty()) {
            TConsultation.Diagnoses ret = this.config.getFactory().createTConsultationDiagnoses();
            for (Encounter enc : encounters) {
                IcpcCode reason;
                IcpcCode diag = enc.getDiag();
                if (diag != null) {
                    TDiagnose tDiag = this.config.getFactory().createTDiagnose();
                    tDiag.setIcpc(diag.getCode());
                    tDiag.setDescription(diag.getText());
                    ret.getDiagnose().add(tDiag);
                }
                if ((reason = enc.getRFE()) == null) continue;
                TDiagnose tReason = this.config.getFactory().createTDiagnose();
                tReason.setIcpc(reason.getCode());
                tReason.setDescription(reason.getText());
                ret.getReason().add(tReason);
            }
            if (!ret.getDiagnose().isEmpty()) {
                return Optional.of(ret);
            }
        }
        return Optional.empty();
    }
}

