/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.message.core.message;

import ca.uhn.hl7v2.HL7Exception;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.hl7.data.HL7Konsultation;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.data.HL7Patient;
import ch.elexis.hl7.message.core.message.HL7MessageUtil;
import ch.elexis.hl7.message.core.message.IHL7Message;
import ch.elexis.hl7.v231.HL7_ADT_A08;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ADT_A08Message
implements IHL7Message {
    @Override
    public List<String> validateContext(Map<String, Object> context) {
        ArrayList<String> ret = new ArrayList<String>();
        if (context.get("context.patient") == null) {
            ret.add("context.patient");
        }
        if (context.get("context.mandator") == null) {
            ret.add("context.mandator");
        }
        if (context.get("context.consultation") == null) {
            ret.add("context.consultation");
        }
        return ret;
    }

    @Override
    public String getMessage(Map<String, Object> context) throws ElexisException {
        if (context != null && !context.isEmpty()) {
            String uniqueMessageControlID = StringTool.unique((String)"MessageControlID");
            String uniqueProcessingID = StringTool.unique((String)"ProcessingID");
            String receivingApplication = (String)context.get("context.msg.receivingapplication");
            String receivingFacility = (String)context.get("context.msg.receivingfacility");
            Mandant eMandant = (Mandant)context.get("context.mandator");
            HL7Mandant mandant = HL7MessageUtil.mandantOf(eMandant);
            HL7_ADT_A08 message = new HL7_ADT_A08("CHELEXIS", "PATDATA", receivingApplication, "", receivingFacility, uniqueMessageControlID, uniqueProcessingID, mandant);
            Patient ePatient = (Patient)context.get("context.patient");
            HL7Patient patient = HL7MessageUtil.patientOf(ePatient);
            Konsultation eConsultation = (Konsultation)context.get("context.consultation");
            HL7Konsultation consultation = HL7MessageUtil.consultationOf(eConsultation);
            try {
                return message.createText(patient, consultation);
            }
            catch (HL7Exception e) {
                throw new ElexisException("Error creating HL7 message, see wrapped exception", (Throwable)e);
            }
        }
        throw new ElexisException("No context for creating HL7 message available");
    }

    @Override
    public String getHL7Version() {
        return "2.3.1";
    }
}

