/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Patient;
import ch.elexis.global_inbox.Activator;
import ch.elexis.global_inbox.InboxContentProvider;
import ch.elexis.global_inbox.InboxLabelProvider;
import ch.elexis.global_inbox.Messages;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class InboxView
extends ViewPart {
    private TableViewer tv;
    private IAction addAction;
    private IAction deleteAction;
    private IAction execAction;
    private IAction reloadAction;
    String[] columnHeaders = new String[]{Messages.InboxView_category, Messages.InboxView_title};
    TableColumn[] tc;
    private IStatus inboxConfigStat;
    private boolean configErrorShown = false;

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 65536);
        this.tv = new TableViewer(table);
        this.tc = new TableColumn[this.columnHeaders.length];
        int i = 0;
        while (i < this.tc.length) {
            this.tc[i] = new TableColumn(table, 0);
            this.tc[i].setText(this.columnHeaders[i]);
            this.tc[i].setWidth(100);
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        InboxContentProvider cp = Activator.getDefault().getContentProvider();
        this.makeActions();
        this.tv.setContentProvider((IContentProvider)cp);
        this.tv.setLabelProvider((IBaseLabelProvider)new InboxLabelProvider());
        this.tv.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                File f1 = (File)e1;
                File f2 = (File)e2;
                return f1.getAbsolutePath().compareTo(f2.getAbsolutePath());
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)InboxView.this.tv.getSelection();
                InboxView.this.addAction.setEnabled(!sel.isEmpty());
                InboxView.this.deleteAction.setEnabled(!sel.isEmpty());
                InboxView.this.execAction.setEnabled(!sel.isEmpty());
            }
        });
        cp.setView(this);
        this.inboxConfigStat = cp.reload();
        this.tv.setInput((Object)this);
        final MenuManager mgr = new MenuManager();
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                mgr.add(InboxView.this.addAction);
                mgr.add(InboxView.this.execAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(InboxView.this.deleteAction);
            }
        });
        mgr.setRemoveAllWhenShown(true);
        table.setMenu(mgr.createContextMenu((Control)table));
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createToolbar(new IAction[]{this.addAction, this.execAction, this.reloadAction, null, this.deleteAction});
        this.addAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.execAction.setEnabled(false);
    }

    public void dispose() {
        Activator.getDefault().getContentProvider().setView(null);
        super.dispose();
    }

    public void setFocus() {
        if (!this.inboxConfigStat.isOK() && !this.configErrorShown) {
            SWTHelper.alert((String)Messages.Activator_noInbox, (String)Messages.InboxContentProvider_noInboxDefined);
            this.configErrorShown = true;
        }
    }

    public void reload() {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                InboxView.this.tv.refresh();
            }
        });
    }

    public File getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return (File)sel.getFirstElement();
    }

    private void makeActions() {
        this.addAction = new Action(Messages.InboxView_assign){
            {
                this.setToolTipText(Messages.InboxView_assignThisDocument);
                this.setImageDescriptor(Images.IMG_OK.getImageDescriptor());
            }

            public void run() {
                File sel = InboxView.this.getSelection();
                Patient pat = ElexisEventDispatcher.getSelectedPatient();
                if (sel != null && pat != null) {
                    long heapSize = Runtime.getRuntime().totalMemory();
                    long length = sel.length();
                    if (length >= heapSize) {
                        MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)"Fehler bei Import", (String)("Kann " + sel.getAbsolutePath() + " nicht importieren, da groesser heap size. (#3652)"));
                        return;
                    }
                    if (SWTHelper.askYesNo((String)Messages.InboxView_inbox, (String)MessageFormat.format(Messages.InboxView_assignxtoy, sel.getName(), pat.getLabel()))) {
                        IDocumentManager dm = (IDocumentManager)Extensions.findBestService((String)"DocumentManagement");
                        try {
                            String cat = Activator.getDefault().getCategory(sel);
                            if (cat.equals("-")) {
                                cat = "";
                            }
                            InboxView.this.tv.remove((Object)sel);
                            GenericDocument fd = new GenericDocument(pat, sel.getName(), cat, sel, new TimeTool().toString(4), "", null);
                            boolean bSucc = sel.delete();
                            sel = null;
                            if (CoreHub.localCfg.get("plugins/global_inbox/autobilling", false)) {
                                dm.addDocument((IOpaqueDocument)fd, true);
                            } else {
                                dm.addDocument((IOpaqueDocument)fd);
                            }
                            fd = null;
                            Activator.getDefault().getContentProvider().reload();
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            SWTHelper.alert((String)Messages.InboxView_error, (String)ex.getMessage());
                        }
                    }
                }
            }
        };
        this.deleteAction = new Action(Messages.InboxView_delete){
            {
                this.setToolTipText(Messages.InboxView_reallydelete);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                File sel = InboxView.this.getSelection();
                if (SWTHelper.askYesNo((String)Messages.InboxView_inbox, (String)MessageFormat.format(Messages.InboxView_thisreallydelete, sel.getName()))) {
                    sel.delete();
                    InboxView.this.reloadInbox();
                }
            }
        };
        this.execAction = new Action(Messages.InboxView_view){
            {
                this.setToolTipText(Messages.InboxView_viewThisDocument);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            public void run() {
                try {
                    File sel = InboxView.this.getSelection();
                    String ext = FileTool.getExtension((String)sel.getName());
                    Program proggie = Program.findProgram((String)ext);
                    String arg = sel.getAbsolutePath();
                    if (proggie != null) {
                        proggie.execute(arg);
                    } else if (!Program.launch((String)sel.getAbsolutePath())) {
                        Runtime.getRuntime().exec(arg);
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.showError((String)Messages.InboxView_couldNotStart, (String)ex.getMessage());
                }
            }
        };
        this.reloadAction = new Action(Messages.InboxView_reload){
            {
                this.setToolTipText(Messages.InboxView_reloadNow);
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                InboxView.this.reloadInbox();
            }
        };
    }

    private void reloadInbox() {
        IStatus status = Activator.getDefault().getContentProvider().reload();
        if (status == Status.CANCEL_STATUS) {
            SWTHelper.showError((String)Messages.InboxView_error, (String)Messages.InvoxView_errorCantDetectInbox);
        }
    }
}

