/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonContentProviderAdapter;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.global_inbox.Activator;
import ch.elexis.global_inbox.InboxView;
import ch.elexis.global_inbox.Messages;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxContentProvider
extends CommonContentProviderAdapter {
    private static Logger log = LoggerFactory.getLogger(InboxContentProvider.class);
    private static final String LOCAL_LOCK_INBOXIMPORT = "GlobalInboxImport";
    ArrayList<File> files = new ArrayList();
    InboxView view;
    LoadJob loader;
    Pattern patMatch = Pattern.compile("([0-9]+)_(.+)");

    public void setView(InboxView view) {
        this.view = view;
    }

    public void dispose() {
        super.dispose();
    }

    public IStatus reload() {
        return this.loader.run(null);
    }

    public InboxContentProvider() {
        this.loader = new LoadJob();
        this.loader.schedule(1000L);
    }

    public Object[] getElements(Object inputElement) {
        return this.files == null ? null : this.files.toArray();
    }

    private void addFiles(List<File> list, File dir) {
        File[] contents;
        File[] fileArray = contents = dir.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.addFiles(list, file);
                } else {
                    Matcher matcher = this.patMatch.matcher(file.getName());
                    if (matcher.matches()) {
                        String num = matcher.group(1);
                        String nam = matcher.group(2);
                        List lPat = new Query(Patient.class, "PatientNr", num).execute();
                        if (lPat.size() == 1 && !this.isFileOpened(file)) {
                            Patient pat = (Patient)lPat.get(0);
                            String cat = Activator.getDefault().getCategory(file);
                            if (cat.equals("-") || cat.equals("??")) {
                                cat = null;
                            }
                            IDocumentManager dm = (IDocumentManager)Extensions.findBestService((String)"DocumentManagement");
                            try {
                                long heapSize = Runtime.getRuntime().totalMemory();
                                long length = file.length();
                                if (length >= heapSize) {
                                    log.warn("Skipping " + file.getAbsolutePath() + " as bigger than heap size. (#3652)");
                                    break block11;
                                }
                                GenericDocument fd = new GenericDocument(pat, nam, cat, file, new TimeTool().toString(4), "", null);
                                file.delete();
                                if (CoreHub.localCfg.get("plugins/global_inbox/autobilling", false)) {
                                    dm.addDocument((IOpaqueDocument)fd, true);
                                } else {
                                    dm.addDocument((IOpaqueDocument)fd);
                                }
                            }
                            catch (Exception ex) {
                                ExHandler.handle((Throwable)ex);
                                SWTHelper.alert((String)Messages.InboxView_error, (String)ex.getMessage());
                            }
                        }
                    }
                    list.add(file);
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isFileOpened(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                try {
                    Throwable throwable2 = null;
                    Object var6_11 = null;
                    FileLock lock = channel.lock();
                    if (lock != null) {
                        lock.close();
                    }
                    try {
                        if (channel != null) {
                            channel.close();
                        }
                        return false;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (lock != null) {
                                lock.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            try {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                            catch (OverlappingFileLockException overlappingFileLockException) {
                                if (channel != null) {
                                    channel.close();
                                }
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (channel != null) {
                        channel.close();
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    class LoadJob
    extends Job {
        public LoadJob() {
            super("GlobalInbox");
            this.setPriority(50);
            this.setUser(false);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LocalLock lock = new LocalLock((Object)InboxContentProvider.LOCAL_LOCK_INBOXIMPORT);
            if (lock.tryLock()) {
                String filepath = CoreHub.localCfg.get("plugins/global_inbox/dir", null);
                File dir = null;
                if (filepath == null) {
                    filepath = "";
                    CoreHub.localCfg.set("plugins/global_inbox/dir", "");
                }
                if (!(dir = new File(filepath)).isDirectory()) {
                    if (InboxContentProvider.this.view != null) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
                Object dm = Extensions.findBestService((String)"DocumentManagement");
                if (dm == null) {
                    log.warn("No document management service found.");
                    return Status.OK_STATUS;
                }
                IDocumentManager documentManager = (IDocumentManager)dm;
                String[] cats = documentManager.getCategories();
                if (cats != null) {
                    String[] stringArray = cats;
                    int n = cats.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cat = stringArray[n2];
                        File subdir = new File(dir, cat);
                        if (!subdir.exists()) {
                            subdir.mkdirs();
                        }
                        ++n2;
                    }
                }
                InboxContentProvider.this.files.clear();
                log.info("Adding documents from [" + dir.getAbsolutePath() + "]");
                InboxContentProvider.this.addFiles(InboxContentProvider.this.files, dir);
                if (InboxContentProvider.this.view != null) {
                    InboxContentProvider.this.view.reload();
                }
                this.schedule(120000L);
            } else {
                log.info("Skipping document import, lock present.");
                long lockMillis = lock.getLockCurrentMillis();
                if (lockMillis == -1L || System.currentTimeMillis() - lockMillis > 240000L) {
                    log.warn("Removing pending lock " + lock.getLockMessage() + "@" + lockMillis);
                    lock.unlock();
                }
            }
            LocalLock.getManagedLock((Object)InboxContentProvider.LOCAL_LOCK_INBOXIMPORT).ifPresent(localDocumentLock -> localDocumentLock.unlock());
            return Status.OK_STATUS;
        }
    }
}

