/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.global_inbox;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.global_inbox.InboxContentProvider;
import ch.elexis.global_inbox.Messages;
import java.io.File;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "ch.elexis.global_inbox";
    private static Activator plugin;
    private InboxContentProvider contentProvider = new InboxContentProvider();

    public void start(BundleContext context) throws Exception {
        File giDir;
        boolean created;
        super.start(context);
        plugin = this;
        String giDirSetting = CoreHub.localCfg.get("plugins/global_inbox/dir", "NOTSET");
        if ("NOTSET".equals(giDirSetting) && (created = (giDir = new File(CoreHub.getWritableUserDir(), "GlobalInbox")).mkdir())) {
            CoreHub.localCfg.set("plugins/global_inbox/dir", giDir.getAbsolutePath());
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public InboxContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void earlyStartup() {
    }

    public String getCategory(File file) {
        String dir = CoreHub.localCfg.get("plugins/global_inbox/dir", "");
        File parent = file.getParentFile();
        if (parent == null) {
            return Messages.Activator_noInbox;
        }
        String fname = parent.getAbsolutePath();
        if (fname.startsWith(dir)) {
            if (fname.length() > dir.length()) {
                return fname.substring(dir.length() + 1);
            }
            return "-";
        }
        return "??";
    }
}

