/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.omnivore;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.extdoc.omnivore.DocumentStoreHolder;
import ch.elexis.extdoc.preferences.PreferenceConstants;
import ch.elexis.extdoc.util.MatchPatientToPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class OmnivoreImporter {
    public boolean isAvailable() {
        return DocumentStoreHolder.get().isPresent();
    }

    public Optional<ICategory> getCategory() {
        CategorySelectionDialog dialog;
        if (DocumentStoreHolder.get().isPresent() && (dialog = new CategorySelectionDialog(Display.getDefault().getActiveShell())).open() == 0) {
            return Optional.ofNullable(dialog.getSelectedCategory());
        }
        return Optional.empty();
    }

    public void importAll(ICategory category, IProgressMonitor progress) {
        Query query = new Query(Patient.class);
        List allPatients = query.execute();
        progress.beginTask("Externe Dokumente Importieren ...", allPatients.size());
        String[] activePaths = PreferenceConstants.getActiveBasePaths();
        int i = 0;
        while (i < allPatients.size()) {
            progress.setTaskName("Externe Dokumente Importieren (" + i + "/" + allPatients.size() + ")");
            this.importPatient(category, (Patient)allPatients.get(i), activePaths);
            progress.worked(1);
            if (progress.isCanceled()) break;
            ++i;
        }
    }

    public void importPatient(ICategory category, Patient patient, String[] activePaths) {
        Object object = MatchPatientToPath.getFilesForPatient(patient, activePaths);
        if (object instanceof List) {
            List list = (List)object;
            List importedDocuments = DocumentStoreHolder.get().get().getDocuments(patient.getId(), null, category, null);
            for (File file : list) {
                boolean imported = false;
                String fileName = file.getName();
                if (!importedDocuments.isEmpty()) {
                    for (IDocument iDocument : importedDocuments) {
                        if (!iDocument.getTitle().equals(fileName)) continue;
                        imported = true;
                    }
                }
                if (imported) continue;
                IDocument document = DocumentStoreHolder.get().get().createDocument(patient.getId(), fileName, category.getName());
                try {
                    Object object2 = null;
                    Object var13_15 = null;
                    try (FileInputStream fis = new FileInputStream(file);){
                        DocumentStoreHolder.get().get().saveDocument(document, (InputStream)fis);
                    }
                    catch (Throwable throwable) {
                        if (object2 == null) {
                            object2 = throwable;
                        } else if (object2 != throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                        throw object2;
                    }
                }
                catch (ElexisException | IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error importing file [" + file.getAbsolutePath() + "]", e);
                }
            }
        }
    }

    public class CategorySelectionDialog
    extends TitleAreaDialog {
        private ComboViewer categoriesViewer;
        private ICategory selectedCategory;

        public CategorySelectionDialog(Shell parentShell) {
            super(parentShell);
        }

        public ICategory getSelectedCategory() {
            return this.selectedCategory;
        }

        public void create() {
            super.create();
            this.setTitle("Omnivore Kategorie Auswahl");
            this.setMessage("Omnivore Kategorie in die die ext. Dokumente importiert werden sollen ausw\u00e4hlen.");
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)new GridData(4, 4, true, true));
            this.categoriesViewer = new ComboViewer(ret, 2048);
            this.categoriesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.categoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ICategory) {
                        return ((ICategory)element).getName();
                    }
                    return super.getText(element);
                }
            });
            this.categoriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = CategorySelectionDialog.this.categoriesViewer.getStructuredSelection();
                    if (selection.isEmpty()) {
                        CategorySelectionDialog.this.selectedCategory = null;
                    } else {
                        CategorySelectionDialog.this.selectedCategory = (ICategory)selection.getFirstElement();
                    }
                }
            });
            this.categoriesViewer.setInput((Object)DocumentStoreHolder.get().get().getCategories());
            this.categoriesViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            return ret;
        }
    }
}

