/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import ch.docbox.ws.cdachservicesv2.CDACHServicesV2_Service;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.docbox.ws.client.WsClientUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class WsClientConfig {
    public static String TESTLOGINIDPREFIX = "TEST_";
    public static final String USR_DEFDOCBXLOGINID = "docbox/loginid";
    public static final String USR_DEFDOCBOXPASSWORD = "docbox/password";
    public static final String USR_SECRETKEY = "docbox/secretkey";
    public static final String USR_DEFDOCBOXP12PATH = "docbox/p12path";
    public static final String USR_DEFDOCBOXP12PASSWORD = "docbox/p12password";

    public static String getUsername() {
        if (CoreHub.mandantCfg != null) {
            return WsClientConfig.getDocboxLoginID(false);
        }
        return "";
    }

    public static String getPassword() {
        if (CoreHub.mandantCfg != null) {
            return WsClientConfig.getSha1DocboxPassword();
        }
        return "";
    }

    public static String getSecretkey() {
        if (CoreHub.mandantCfg != null) {
            return WsClientConfig.getSha1DocboxSecretKey();
        }
        return "";
    }

    public static String getP12Path() {
        if (CoreHub.mandantCfg != null) {
            return CoreHub.mandantCfg.get(USR_DEFDOCBOXP12PATH, "");
        }
        return "";
    }

    public static String getP12Password() {
        if (CoreHub.mandantCfg != null) {
            return CoreHub.mandantCfg.get(USR_DEFDOCBOXP12PASSWORD, "");
        }
        return "";
    }

    public static String getDocboxServiceUrl() {
        String test = WsClientConfig.isDocboxTest() ? "test" : "";
        String host = WsClientConfig.getHost();
        return "https://" + host + "/cgi-bin/WebObjects/docboxservice" + test + ".woa/ws/CDACHServicesV2";
    }

    private static String getHost() {
        String host = "";
        host = WsClientConfig.isDocboxTest() ? "ihe.test.docbox.ch" : "ihe.docbox.ch";
        return host;
    }

    private static String getSha1DocboxSecretKey() {
        String docboxSha1SecretKey = "";
        if (WsClientConfig.isDocboxTest()) {
            return WsClientUtil.getSHA1("docboxtest");
        }
        URL baseUrl = CDACHServicesV2_Service.class.getResource("");
        try {
            URL url = new URL(baseUrl + "/product.key");
            InputStream in = url.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            docboxSha1SecretKey = bufferedReader.readLine();
        }
        catch (Exception e) {
            docboxSha1SecretKey = WsClientUtil.getSHA1(CoreHub.mandantCfg.get(USR_SECRETKEY, ""));
        }
        return docboxSha1SecretKey;
    }

    private static boolean isDocboxTest() {
        return WsClientConfig.getDocboxLoginID(true) != null && WsClientConfig.getDocboxLoginID(true).startsWith("TEST_");
    }

    private static String getDocboxLoginID(boolean prefixed) {
        String loginId = CoreHub.mandantCfg.get(USR_DEFDOCBXLOGINID, "");
        if (!prefixed && loginId.startsWith(TESTLOGINIDPREFIX)) {
            loginId = loginId.substring(TESTLOGINIDPREFIX.length());
        }
        return loginId;
    }

    public static String getSha1DocboxPassword() {
        String sha1Password = CoreHub.mandantCfg.get(USR_DEFDOCBOXPASSWORD, "");
        return sha1Password;
    }
}

