/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.hl7.v3.POCDMT000040ClinicalDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdaUtil {
    private static Logger logger = LoggerFactory.getLogger(CdaUtil.class);
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;

    public static synchronized Unmarshaller getCdaUnmarshaller() {
        if (unmarshaller == null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.hl7.v3");
                unmarshaller = jaxbContext.createUnmarshaller();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return null;
            }
        }
        return unmarshaller;
    }

    public static synchronized Marshaller getMarshaller() {
        if (marshaller == null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.hl7.v3");
                marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
                marshaller.setProperty("jaxb.schemaLocation", (Object)"urn:hl7-org:v3 CDA.xsd");
                marshaller.setProperty("jaxb.fragment", (Object)new Boolean(true));
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return marshaller;
    }

    public static POCDMT000040ClinicalDocument unmarshall(InputStream source) throws JAXBException {
        Unmarshaller unmarshaller = CdaUtil.getCdaUnmarshaller();
        JAXBElement doc = unmarshaller.unmarshal((Source)new StreamSource(source), POCDMT000040ClinicalDocument.class);
        return (POCDMT000040ClinicalDocument)doc.getValue();
    }

    public static String marshallIntoString(POCDMT000040ClinicalDocument clinicalDocumentType) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = CdaUtil.getMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName("urn:hl7-org:v3", "ClinicalDocument"), POCDMT000040ClinicalDocument.class, (Object)clinicalDocumentType), (Writer)writer);
        }
        catch (Exception e) {
            logger.error("Could not marshall to string.", (Throwable)e);
            return null;
        }
        return writer.toString();
    }
}

