/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connector.medicosearch.commands;

import ch.elexis.connector.medicosearch.MedicosearchUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMedicosearchHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(SyncMedicosearchHandler.class);
    private static final String JAVA_HOME = "java.home";
    private static final String BIN = "bin";
    private static final String JAVA = "java";
    private static final String RUN_JAR = "-jar";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MedicosearchUtil medicosearchUtil = MedicosearchUtil.getInstance();
        String java = String.valueOf(System.getProperty(JAVA_HOME)) + File.separator + BIN + File.separator + JAVA;
        ProcessBuilder processCmd = new ProcessBuilder(java, RUN_JAR, medicosearchUtil.getMedicosearchJarPath());
        processCmd.directory(medicosearchUtil.getBundleDirectory());
        try {
            String line;
            Process process = processCmd.start();
            InputStream is = process.getInputStream();
            InputStreamReader inStreamReader = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(inStreamReader);
            log.debug(">>> Synchronize Medicosearch <<<");
            while ((line = br.readLine()) != null) {
                log.debug(line);
            }
            log.debug(">>> Medicosearch synchronization finished <<<");
        }
        catch (IOException e) {
            log.error("Error executing medicosearch jar", (Throwable)e);
        }
        return null;
    }
}

