/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connector.medicosearch;

import ch.elexis.connector.medicosearch.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedicosearchUtil {
    private static final Logger log = LoggerFactory.getLogger(MedicosearchUtil.class);
    private static final String BUNDLE_NAME = "ch.elexis.connector.medicosearch";
    private static final String JAR_FILE = "lib/net.medshare.connector.medicosearch_2.1.6.20120925.jar";
    private static final String CONFIG_FILE = "conf/connector.properties";
    private static MedicosearchUtil instance = null;
    private static File bundleDir;
    private static File cfgFile;
    private static File jarFile;

    private MedicosearchUtil() {
        this.initLocations();
    }

    public static MedicosearchUtil getInstance() {
        if (instance == null) {
            instance = new MedicosearchUtil();
        }
        return instance;
    }

    private void initLocations() {
        Bundle bundle = Platform.getBundle((String)BUNDLE_NAME);
        cfgFile = this.resolveByFileURL(CONFIG_FILE, bundle);
        jarFile = this.resolveByFileURL(JAR_FILE, bundle);
        if (cfgFile != null) {
            bundleDir = cfgFile.getParentFile().getParentFile();
            this.updatePreferenceSettingsIfNeeded();
        }
        if (cfgFile == null || jarFile == null) {
            this.showWarningMessage();
        }
    }

    private void updatePreferenceSettingsIfNeeded() {
        String cfgSetting = CoreHub.globalCfg.get("medicosearch/config", null);
        if (cfgSetting == null || !cfgSetting.equals(cfgFile.getAbsolutePath())) {
            CoreHub.globalCfg.set("medicosearch/config", cfgFile.getAbsolutePath());
            CoreHub.globalCfg.flush();
        }
    }

    private File resolveByFileURL(String filePath, Bundle bundle) {
        try {
            File file;
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(filePath), null);
            if (url != null && (file = new File(FileLocator.toFileURL((URL)url).getFile())) != null && file.exists()) {
                return file;
            }
        }
        catch (IOException e) {
            log.error("Error resolving file location [" + filePath + "]", (Throwable)e);
        }
        log.warn("Medicosearch file [" + filePath + "] not found");
        return null;
    }

    private void showWarningMessage() {
        StringBuilder sb = new StringBuilder();
        if (cfgFile == null) {
            sb.append(MessageFormat.format(Messages.ConfigFile, CONFIG_FILE));
        }
        if (jarFile == null) {
            sb.append(MessageFormat.format(Messages.MedicosearchJar, JAR_FILE));
        }
        MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)Messages.Warn_FilesMissing, (String)MessageFormat.format(Messages.Warn_FilesMissingMsg, sb.toString()));
    }

    public String getConfigurationFilePath() {
        if (cfgFile == null) {
            return "";
        }
        return cfgFile.getAbsolutePath();
    }

    public String getMedicosearchJarPath() {
        if (jarFile == null) {
            return "";
        }
        return jarFile.getAbsolutePath();
    }

    public File getBundleDirectory() {
        return bundleDir;
    }
}

