/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.sysmex.packages;

import ch.elexis.connect.sysmex.Messages;
import ch.elexis.connect.sysmex.packages.PackageException;
import ch.elexis.core.data.beans.ContactBean;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.core.ui.importer.div.importers.LabImportUtil;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import java.util.ResourceBundle;

public class Value {
    private static final String KX21_BUNDLE_NAME = "ch.elexis.connect.sysmex.packages.valuetexts_KX21";
    private static final String KX21N_BUNDLE_NAME = "ch.elexis.connect.sysmex.packages.valuetexts_KX21N";
    private static final String POCH_BUNDLE_NAME = "ch.elexis.connect.sysmex.packages.valuetexts_pocH";
    private static final String UC1000_BUNDLE_NAME = "ch.elexis.connect.sysmex.packages.valuetexts_UC1000";
    private final ResourceBundle _bundle;
    Labor _myLab;
    String _shortName;
    String _longName;
    String _unit;
    LabItem _labItem;
    String _refMann;
    String _refFrau;

    public static Value getValueUC1000(String paramName) throws PackageException {
        return new Value(paramName, UC1000_BUNDLE_NAME);
    }

    public static Value getValueKX21(String paramName) throws PackageException {
        return new Value(paramName, KX21_BUNDLE_NAME);
    }

    public static Value getValueKX21N(String paramName) throws PackageException {
        return new Value(paramName, KX21N_BUNDLE_NAME);
    }

    public static Value getValuePOCH(String paramName) throws PackageException {
        return new Value(paramName, POCH_BUNDLE_NAME);
    }

    private Value(String paramName, String bundleName) throws PackageException {
        this._bundle = ResourceBundle.getBundle(bundleName);
        this._shortName = this.getString(paramName, "kuerzel");
        this._longName = this.getString(paramName, "text");
        this._unit = this.getString(paramName, "unit");
        this._refMann = this.getString(paramName, "refM");
        this._refFrau = this.getString(paramName, "refF");
    }

    private void initialize() {
        this._myLab = LabImportUtil.getOrCreateLabor((String)Messages.Sysmex_Value_LabKuerzel);
        this._labItem = LabImportUtil.getLabItem((String)this._shortName, (Labor)this._myLab);
        if (this._labItem == null) {
            this._labItem = new LabItem(this._shortName, this._longName, (Kontakt)this._myLab, this._refMann, this._refFrau, this._unit, LabItemTyp.NUMERIC, Messages.Sysmex_Value_LabName, "50");
        }
    }

    public void fetchValue(Patient patient, String value, Integer flags, TimeTool date) {
        this.fetchValue(patient, value, flags, date, "");
    }

    public void fetchValue(Patient patient, String value, Integer flags, TimeTool date, String comment) {
        if (this._labItem == null) {
            this.initialize();
        }
        LabImportUtil lu = new LabImportUtil();
        TransientLabResult tLabResult = null;
        tLabResult = flags == -1 ? new TransientLabResult.Builder((IPatient)new ContactBean((Kontakt)patient), (IContact)new ContactBean((Kontakt)this._myLab), (ILabItem)this._labItem, value).date(date).comment(comment).build((ILabImportUtil)lu) : new TransientLabResult.Builder((IPatient)new ContactBean((Kontakt)patient), (IContact)new ContactBean((Kontakt)this._myLab), (ILabItem)this._labItem, value).date(date).comment(comment).flags(flags).build((ILabImportUtil)lu);
        lu.importLabResults(Collections.singletonList(tLabResult), (ImportHandler)new DefaultLabImportUiHandler());
    }

    public String get_shortName() {
        return this._shortName;
    }

    public String get_longName() {
        return this._longName;
    }

    private String getString(String paramName, String key) {
        return this._bundle.getString(String.valueOf(paramName) + "." + key);
    }
}

