/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.reflotron;

import ch.elexis.connect.reflotron.DeviceLogger;
import ch.elexis.connect.reflotron.Messages;
import ch.elexis.connect.reflotron.ReflotronConnection;
import ch.elexis.connect.reflotron.packages.PackageException;
import ch.elexis.connect.reflotron.packages.Probe;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.rs232.AbstractConnection;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflotronSprintAction
extends Action
implements AbstractConnection.ComPortListener {
    AbstractConnection _ctrl;
    Labor _myLab;
    DeviceLogger _rs232log;
    private Logger logger = LoggerFactory.getLogger((String)"ReflotronSprintAction");
    Thread msgDialogThread;
    Patient selectedPatient;
    boolean background = false;

    public ReflotronSprintAction() {
        super(Messages.ReflotronSprintAction_ButtonName, 2);
        this.setToolTipText(Messages.ReflotronSprintAction_ToolTip);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.connect.reflotron", (String)"icons/reflotron.png"));
    }

    private void initConnection() {
        if (this._ctrl != null && this._ctrl.isOpen()) {
            this._ctrl.close();
        }
        this._ctrl = new ReflotronConnection(Messages.ReflotronSprintAction_ConnectionName, CoreHub.localCfg.get("connectors/reflotron/port", Messages.ReflotronSprintAction_DefaultPort), CoreHub.localCfg.get("connectors/reflotron/params", Messages.ReflotronSprintAction_DefaultParams), this);
        if (CoreHub.localCfg.get("connectors/reflotron/log", "n").equalsIgnoreCase("y")) {
            try {
                this._rs232log = new DeviceLogger(String.valueOf(System.getProperty("user.home")) + File.separator + "elexis" + File.separator + "reflotron.log");
            }
            catch (FileNotFoundException e) {
                SWTHelper.showError((String)Messages.ReflotronSprintAction_LogError_Title, (String)Messages.ReflotronSprintAction_LogError_Text);
                this._rs232log = new DeviceLogger();
            }
        } else {
            this._rs232log = new DeviceLogger(false);
        }
        this.background = CoreHub.localCfg.get("connectors/reflotron/background", "n").equalsIgnoreCase("y");
    }

    public void run() {
        if (this.isChecked()) {
            this.initConnection();
            this._rs232log.logStart();
            String msg = this._ctrl.connect();
            if (msg == null) {
                String timeoutStr = CoreHub.localCfg.get("connectors/reflotron/timeout", Messages.ReflotronSprintAction_DefaultTimeout);
                int timeout = 20;
                try {
                    timeout = Integer.parseInt(timeoutStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this._ctrl.awaitFrame(UiDesk.getTopShell(), Messages.ReflotronSprintAction_WaitMsg, 1, 4, 0, timeout, this.background, true);
                return;
            }
            this._rs232log.log("Error");
            SWTHelper.showError((String)Messages.ReflotronSprintAction_RS232_Error_Title, (String)msg);
        } else if (this._ctrl.isOpen()) {
            this._ctrl.sendBreak();
            this._ctrl.close();
        }
        this.setChecked(false);
        this._rs232log.logEnd();
    }

    private static void showError(final String title, final String message) {
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = UiDesk.getTopShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public void gotBreak(AbstractConnection connection) {
        connection.close();
        this.setChecked(false);
        this._rs232log.log("Break");
        this._rs232log.logEnd();
        SWTHelper.showError((String)Messages.ReflotronSprintAction_RS232_Break_Title, (String)Messages.ReflotronSprintAction_RS232_Break_Text);
    }

    private String getFirstUpper(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        String retStr = str.toUpperCase();
        if (str.length() > 1) {
            retStr = String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1).trim();
        }
        return retStr;
    }

    private void processProbe(final Probe probe) {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ReflotronSprintAction.this.selectedPatient = ElexisEventDispatcher.getSelectedPatient();
                Patient probePat = null;
                String vorname = null;
                String name = null;
                String patientElexisStr = Messages.ReflotronSprintAction_UnknownPatientHeaderString;
                String patientDeviceStr = probe.getIdent();
                Long patId = null;
                if (patientDeviceStr != null) {
                    String patName = probe.getIdent();
                    String text = MessageFormat.format("patName={0}; resultat={1}; hint={2}, zusatztext={3}", patName, probe.getResultat(), probe.getHint(), probe.getZusatztext());
                    System.out.println(text);
                    ReflotronSprintAction.this.logger.info(text);
                    Query patQuery = new Query(Patient.class);
                    if (patName != null && patName.length() > 0) {
                        List patientList;
                        String[] parts = patName.split(",");
                        if (parts.length > 1) {
                            try {
                                patId = new Long(parts[0]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (patId != null) {
                                name = ReflotronSprintAction.this.getFirstUpper(parts[1]);
                            } else {
                                name = ReflotronSprintAction.this.getFirstUpper(parts[0]);
                                vorname = ReflotronSprintAction.this.getFirstUpper(parts[1]);
                                patQuery.add("Vorname", "like", String.valueOf(vorname) + "%");
                            }
                        } else if (parts.length == 1) {
                            name = ReflotronSprintAction.this.getFirstUpper(parts[0]);
                        }
                        if (patId != null) {
                            patQuery.add("PatientNr", "=", patId.toString());
                        }
                        if (name != null && name.length() > 0) {
                            patQuery.add("Name", "like", String.valueOf(name) + "%");
                        }
                        if (vorname != null && vorname.length() > 0) {
                            patQuery.add("Vorname", "like", String.valueOf(vorname) + "%");
                        }
                        if ((patientList = patQuery.execute()).size() == 1) {
                            probePat = (Patient)patientList.get(0);
                            patientDeviceStr = probe.getIdent();
                            patientElexisStr = String.valueOf(probePat.getName()) + " " + probePat.getVorname();
                        }
                    }
                }
                if (patientDeviceStr == null || patientDeviceStr.equals("")) {
                    patientDeviceStr = Messages.ReflotronSprintAction_NoPatientInfo;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                String warning = "";
                String text = MessageFormat.format(Messages.ReflotronSprintAction_ValueInfoMsg, patientDeviceStr, patientElexisStr, sdf.format(probe.getDate().getTime()), probe.getResultat(), warning);
                boolean ok = MessageDialog.openConfirm((Shell)UiDesk.getTopShell(), (String)Messages.ReflotronSprintAction_DeviceName, (String)text);
                if (ok) {
                    boolean showSelectionDialog = false;
                    if (probePat != null) {
                        ReflotronSprintAction.this.selectedPatient = probePat;
                    } else {
                        showSelectionDialog = true;
                    }
                    if (showSelectionDialog) {
                        UiDesk.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                KontaktSelektor ksl = new KontaktSelektor(Hub.getActiveShell(), Patient.class, Messages.ReflotronSprintAction_Patient_Title, Messages.ReflotronSprintAction_Patient_Text, Patient.DEFAULT_SORT);
                                ksl.create();
                                ksl.getShell().setText(Messages.ReflotronSprintAction_Patient_Title);
                                (this).ReflotronSprintAction.this.selectedPatient = ksl.open() == 0 ? (Patient)ksl.getSelection() : null;
                            }
                        });
                    }
                    if (ReflotronSprintAction.this.selectedPatient != null) {
                        try {
                            String warnMsg = probe.write(ReflotronSprintAction.this.selectedPatient);
                            if (warnMsg != null && warnMsg.length() != 0) {
                                ReflotronSprintAction.this._rs232log.log("Warn: " + warnMsg);
                            }
                        }
                        catch (PackageException e) {
                            ReflotronSprintAction.showError(Messages.ReflotronSprintAction_ProbeError_Title, e.getMessage());
                        }
                    } else {
                        ReflotronSprintAction.showError(Messages.ReflotronSprintAction_Patient_Title, Messages.ReflotronSprintAction_NoPatientMsg);
                    }
                }
            }
        });
    }

    public void gotData(AbstractConnection connection, byte[] data) {
        String encoding = CoreHub.localCfg.get("connectors/reflotron/encoding", Charset.defaultCharset().displayName());
        String content = null;
        try {
            content = new String(data, encoding);
        }
        catch (UnsupportedEncodingException e) {
            ReflotronSprintAction.showError("Reflotron", MessageFormat.format("Encoding ''{0}'' unbekannt", encoding));
        }
        if (content != null) {
            this._rs232log.logRX(content);
            String[] strArray = content.split("\r\n");
            if (strArray.length > 3) {
                Probe probe = new Probe(strArray);
                this.processProbe(probe);
            } else if (content.length() > 0) {
                ReflotronSprintAction.showError("Reflotron", String.valueOf(Messages.ReflotronSprintAction_IncompleteDataRecordMsg) + content + Messages.ReflotronSprintAction_ResendMsg);
            }
            this._rs232log.log("Saved");
        }
        ElexisEventDispatcher.reload(LabItem.class);
    }

    public void closed() {
        this._ctrl.close();
        this._rs232log.log("Closed");
        this.setChecked(false);
        this._rs232log.logEnd();
    }

    public void cancelled() {
        this._ctrl.close();
        this._rs232log.log("Cancelled");
        this.setChecked(false);
        this._rs232log.logEnd();
    }

    public void timeout() {
        this._ctrl.close();
        this._rs232log.log("Timeout");
        SWTHelper.showError((String)Messages.ReflotronSprintAction_RS232_Timeout_Title, (String)Messages.ReflotronSprintAction_RS232_Timeout_Text);
        this.setChecked(false);
        this._rs232log.logEnd();
    }
}

