/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.mythic;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String MYTHIC_BASE = "connectors/mythic/";
    public static final String PORT = "connectors/mythic/port";
    public static final String PARAMS = "connectors/mythic/params";
    Combo ports;
    Text speed;
    Text data;
    Text stop;
    Button parity;

    public Preferences() {
        super("Mythic");
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected Control createContents(Composite parent) {
        String[] param = CoreHub.localCfg.get(PARAMS, "9600,8,n,1").split(",");
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        new Label(ret, 0).setText("Com-Port");
        this.ports = new Combo(ret, 4);
        this.ports.setItems(Connection.getComPorts());
        this.ports.setText(CoreHub.localCfg.get(PORT, "COM1"));
        new Label(ret, 0).setText("Geschwindigkeit");
        this.speed = new Text(ret, 2048);
        this.speed.setText(this.getParamText(param, 0));
        new Label(ret, 0).setText("Datenbits");
        this.data = new Text(ret, 2048);
        this.data.setText(this.getParamText(param, 1));
        new Label(ret, 0).setText("Parity");
        this.parity = new Button(ret, 32);
        this.parity.setSelection(!this.getParamText(param, 2).equalsIgnoreCase("n"));
        new Label(ret, 0).setText("Stopbits");
        this.stop = new Text(ret, 2048);
        this.stop.setText(this.getParamText(param, 3));
        return ret;
    }

    private String getParamText(String[] param, int idx) {
        if (idx < param.length) {
            return param[idx];
        }
        return "";
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.speed.getText()).append(",").append(this.data.getText()).append(",").append(this.parity.getSelection() ? "y" : "n").append(",").append(this.stop.getText());
        CoreHub.localCfg.set(PARAMS, sb.toString());
        CoreHub.localCfg.set(PORT, this.ports.getText());
        CoreHub.localCfg.flush();
        return super.performOk();
    }
}

