/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.model;

import ch.elexis.buchhaltung.model.Messages;
import ch.elexis.buchhaltung.util.PatientIdFormatter;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.SetDataException;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class OffenePostenListe
extends AbstractDataProvider {
    private static final String OFFENE_RECHNUNGEN_PER = Messages.OffenePostenListe_OpenBillsPer;
    private static final String OFFENE_POSTEN = Messages.OffenePostenListe_Open;
    private static final String ANALYSIERE_RECHNUNGEN = Messages.OffenePostenListe_AnalyzingBills;
    private static final String DATENBANKABFRAGE = Messages.OffenePostenListe_DatabaseQuery;
    private static final String NAME = OFFENE_POSTEN;
    private static final String FIELD_ACTMANDATOR = "Nur aktueller Mandant";
    private static final String FIELD_AUSGANGSDATUM = "Ausgangsdatum";
    private static final String FIELD_STICHTAG = "Stichtag";
    private TimeTool stichtag = new TimeTool();
    private TimeTool startTag = new TimeTool();
    private boolean bOnlyActiveMandator;

    public OffenePostenListe() {
        super(NAME);
        this.startTag.set(2, 0);
        this.startTag.set(5, 1);
    }

    public void setStartTag(TimeTool starttag) {
        this.startTag.set(starttag);
    }

    public TimeTool getStartTag() {
        return new TimeTool(this.startTag);
    }

    public void setStichtag(TimeTool stichtag) {
        this.stichtag.set(stichtag);
    }

    public TimeTool getStichtag() {
        return new TimeTool(this.stichtag);
    }

    @GetProperty(name="Nur aktueller Mandant", widgetType=WidgetTypes.BUTTON_CHECKBOX)
    public boolean getOnlyActiveMandator() {
        return this.bOnlyActiveMandator;
    }

    @SetProperty(name="Nur aktueller Mandant")
    public void setOnlyActiveMandator(boolean val) {
        this.bOnlyActiveMandator = val;
    }

    @GetProperty(name="Ausgangsdatum", widgetType=WidgetTypes.TEXT_DATE)
    public String metaGetStarttag() {
        return this.getStartTag().toString(11);
    }

    @SetProperty(name="Ausgangsdatum", index=-2)
    public void metaSetStarttag(String tag) throws SetDataException {
        TimeTool tt = new TimeTool(tag);
        this.setStartTag(tt);
    }

    @GetProperty(name="Stichtag", widgetType=WidgetTypes.TEXT_DATE)
    public String metaGetStichtag() {
        return this.getStichtag().toString(11);
    }

    @SetProperty(name="Stichtag")
    public void metaSetStichtag(String stichtag) throws SetDataException {
        TimeTool tt = new TimeTool(stichtag);
        this.setStichtag(tt);
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        int totalwork = 1000000;
        monitor.beginTask(String.valueOf(OFFENE_RECHNUNGEN_PER) + this.getStichtag().toString(11), totalwork);
        monitor.subTask(DATENBANKABFRAGE);
        Query qbe = new Query(Rechnung.class);
        qbe.add("RnDatum", "<=", this.getStichtag().toString(9));
        qbe.add("RnDatum", ">=", this.getStartTag().toString(9));
        if (this.bOnlyActiveMandator) {
            qbe.add("MandantID", "=", CoreHub.actMandant.getId());
        }
        List rnn = qbe.execute();
        monitor.worked(1000);
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        int size = rnn.size();
        if (size == 0) {
            monitor.done();
            this.dataSet.setContent(result);
            return Status.OK_STATUS;
        }
        int step = totalwork / size;
        monitor.subTask(ANALYSIERE_RECHNUNGEN);
        TimeTool now = this.getStichtag();
        PatientIdFormatter pif = new PatientIdFormatter(8);
        for (Rechnung rn : rnn) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Fall fall = rn.getFall();
            if (fall != null) {
                int status;
                Patient pat = fall.getPatient();
                Money betrag = rn.getBetrag();
                if (pat != null && betrag != null && !betrag.isNeglectable() && RnStatus.isActive((int)(status = rn.getStatusAtDate(now)))) {
                    Comparable[] row = new Comparable[this.getDataSet().getHeadings().size()];
                    row[0] = pif.format(pat.get("PatientNr"));
                    row[1] = rn.getNr();
                    List zahlungen = rn.getZahlungen();
                    for (Zahlung z : zahlungen) {
                        TimeTool tt = new TimeTool(z.getDatum());
                        if (tt.isAfter(now)) continue;
                        betrag.subtractMoney(z.getBetrag());
                    }
                    row[3] = betrag.getAmountAsString();
                    row[2] = RnStatus.getStatusText((int)status);
                    result.add(row);
                }
            }
            monitor.worked(step);
        }
        this.dataSet.setContent(result);
        monitor.done();
        return Status.OK_STATUS;
    }

    protected List<String> createHeadings() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Messages.OffenePostenListe_PatientNr);
        ret.add(Messages.OffenePostenListe_BillNr);
        ret.add(Messages.OffenePostenListe_BillState);
        ret.add(Messages.OffenePostenListe_OpenAmount);
        return ret;
    }

    public String getDescription() {
        return OFFENE_POSTEN;
    }
}

