/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.model;

import ch.elexis.buchhaltung.model.Messages;
import ch.elexis.buchhaltung.util.DateTool;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractTimeSeries;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FakturaJournalDetail
extends AbstractTimeSeries {
    private static final String NAME = Messages.FakturaJournalDetail_Name;
    private boolean bOnlyActiveMandator;

    public FakturaJournalDetail() {
        super(NAME);
    }

    @GetProperty(name="Nur aktueller Mandant", widgetType=WidgetTypes.BUTTON_CHECKBOX, index=1)
    public boolean getOnlyActiveMandator() {
        return this.bOnlyActiveMandator;
    }

    @SetProperty(name="Nur aktueller Mandant", index=1)
    public void setOnlyActiveMandator(boolean val) {
        this.bOnlyActiveMandator = val;
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        int total = 10000000;
        Query qbe = new Query(AccountTransaction.class);
        TimeTool ttStart = new TimeTool(this.getStartDate().getTimeInMillis());
        TimeTool ttEnd = new TimeTool(this.getEndDate().getTimeInMillis());
        qbe.add("Datum", ">=", ttStart.toString(9));
        qbe.add("Datum", "<=", ttEnd.toString(9));
        monitor.beginTask(NAME, total);
        monitor.subTask(Messages.FakturaJournal_DatabaseQuery);
        List transactions = qbe.execute();
        int sum = transactions.size();
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        if (sum == 0) {
            monitor.done();
            this.dataSet.setContent(result);
            return Status.OK_STATUS;
        }
        int step = total / sum;
        monitor.worked(20 * step);
        String actMnId = CoreHub.actMandant.getId();
        for (AccountTransaction at : transactions) {
            Patient pat = at.getPatient();
            Rechnung rn = at.getRechnung();
            if (pat != null && rn != null) {
                Mandant mn;
                if (this.bOnlyActiveMandator && (mn = rn.getMandant()) != null && !mn.getId().equals(actMnId)) continue;
                Kontakt garant = rn.getFall().getGarant();
                Mandant mandant = rn.getMandant();
                Object rechnungssteller = null;
                rechnungssteller = mandant.getRechnungssteller() != null ? mandant.getRechnungssteller() : mandant;
                Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                row[0] = pat.getLabel(false);
                row[1] = rechnungssteller != null ? rechnungssteller.getLabel(true) : "";
                row[2] = garant != null ? garant.getLabel(true) : "";
                row[3] = new DateTool(at.getDate());
                row[4] = at.getAmount();
                row[6] = at.getRemark();
                row[5] = ((Money)row[4]).isNegative() ? Messages.FakturaJournal_FA : (((String)((Object)row[6])).toLowerCase().contains("storno") ? Messages.FakturaJournal_ST : Messages.FakturaJournal_GU);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                result.add(row);
            }
            monitor.worked(step);
        }
        this.dataSet.setContent(result);
        monitor.done();
        return Status.OK_STATUS;
    }

    protected List<String> createHeadings() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Messages.FakturaJournalDetail_Patient);
        ret.add(Messages.FakturaJournalDetail_Rechnungssteller);
        ret.add(Messages.FakturaJournalDetail_Rechnungsempfaenger);
        ret.add(Messages.FakturaJournal_Date);
        ret.add(Messages.FakturaJournal_Amount);
        ret.add(Messages.FakturaJournal_Type);
        ret.add(Messages.FakturaJournal_Text);
        return ret;
    }

    public String getDescription() {
        return Messages.FakturaJournalDetail_Beschreibung;
    }
}

