/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.model;

import ch.elexis.buchhaltung.model.Messages;
import ch.elexis.buchhaltung.util.DateTool;
import ch.elexis.buchhaltung.util.PatientIdFormatter;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.TarmedLeistung;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import ch.unibe.iam.scg.archie.model.AbstractTimeSeries;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.LoggerFactory;

public class AlleLeistungen
extends AbstractTimeSeries {
    private static final String NAME = Messages.AlleLeistungen_Title;
    private boolean hasUserId;

    public AlleLeistungen() {
        super(NAME);
        VersionInfo elexisVersion = new VersionInfo(CoreHub.Version);
        this.hasUserId = !elexisVersion.isOlder("2.1.7");
    }

    public String getDescription() {
        return Messages.AlleLeistungen_Description;
    }

    protected List<String> createHeadings() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Messages.AlleLeistungen_InvoicingParty);
        ret.add(Messages.AlleLeistungen_Mandator);
        if (this.hasUserId) {
            ret.add(Messages.AlleLeistungen_User);
        }
        ret.add(Messages.AlleLeistungen_Doctor);
        ret.add(Messages.AlleLeistungen_TreatmentDate);
        ret.add(Messages.AlleLeistungen_PatientName);
        ret.add(Messages.AlleLeistungen_PatientFirstname);
        ret.add(Messages.AlleLeistungen_PatientId);
        ret.add(Messages.AlleLeistungen_PatientDateOfBirth);
        ret.add(Messages.AlleLeistungen_PatientSex);
        ret.add(Messages.AlleLeistungen_PatientZip);
        ret.add(Messages.AlleLeistungen_PatientCity);
        ret.add(Messages.AlleLeistungen_ActivityText);
        ret.add(Messages.AlleLeistungen_TarmedCode);
        ret.add(Messages.AlleLeistungen_TarmedAL);
        ret.add(Messages.AlleLeistungen_TarmedTL);
        ret.add(Messages.AlleLeistungen_TariffType);
        ret.add(Messages.AlleLeistungen_TaxPointValue);
        ret.add(Messages.AlleLeistungen_Quantity);
        ret.add(Messages.AlleLeistungen_PurchaseCosts);
        ret.add(Messages.AlleLeistungen_SaleCosts);
        ret.add(Messages.AlleLeistungen_Sales);
        ret.add(Messages.AlleLeistungen_VAT);
        ret.add(Messages.AlleLeistungen_BillState);
        return ret;
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        int total = 10000000;
        Query qbe = new Query(Konsultation.class);
        TimeTool ttStart = new TimeTool(this.getStartDate().getTimeInMillis());
        TimeTool ttEnd = new TimeTool(this.getEndDate().getTimeInMillis());
        qbe.add("Datum", ">=", ttStart.toString(9));
        qbe.add("Datum", "<=", ttEnd.toString(9));
        monitor.beginTask(NAME, total);
        monitor.subTask(Messages.FakturaJournal_DatabaseQuery);
        List consultations = qbe.execute();
        int sum = consultations.size();
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        if (sum == 0) {
            monitor.done();
            this.dataSet.setContent(result);
            return Status.OK_STATUS;
        }
        int step = total / sum;
        monitor.worked(20 * step);
        PatientIdFormatter pif = new PatientIdFormatter(8);
        long time = System.currentTimeMillis();
        for (Konsultation cons : consultations) {
            Patient patient = cons.getFall().getPatient();
            Mandant mandant = cons.getMandant();
            String billState = cons.getStatusText();
            if (cons.getStatus() >= 19 && cons.getStatus() <= 21) {
                billState = Messages.AlleLeistungen_NoBill;
            }
            String[] cachedData = this.performanceOptimization(patient, mandant);
            List activities = cons.getLeistungen(new String[]{"userID", "Leistg_txt", "VK_Scale", "Zahl", "Scale2", "EK_Kosten", "VK_Preis", "VK_TP"});
            if (mandant != null && patient != null && activities != null && !activities.isEmpty()) {
                for (Verrechnet verrechnet : activities) {
                    IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                    Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                    int index = 0;
                    row[index++] = cachedData[0];
                    row[index++] = cachedData[1];
                    if (this.hasUserId) {
                        String userid = verrechnet.get("userID");
                        Kontakt user = Kontakt.load((String)userid);
                        row[index++] = user.exists() ? user.getLabel() : "";
                    }
                    row[index++] = cachedData[2];
                    row[index++] = new DateTool(cons.getDatum());
                    row[index++] = patient.getName();
                    row[index++] = patient.getVorname();
                    row[index++] = pif.format(patient.get("PatientNr"));
                    row[index++] = new DateTool(patient.getGeburtsdatum());
                    row[index++] = patient.getGeschlecht();
                    row[index++] = cachedData[3];
                    row[index++] = cachedData[4];
                    row[index++] = verrechnet.getText();
                    if (verrechenbar != null) {
                        try {
                            row[index++] = verrechenbar.getCode() == null ? "?" : verrechenbar.getCode();
                            row[index++] = verrechenbar instanceof TarmedLeistung ? Double.toString((double)((TarmedLeistung)verrechenbar).getAL() / 100.0) : "";
                            if (verrechenbar instanceof TarmedLeistung) {
                                row[index++] = Double.toString((double)((TarmedLeistung)verrechenbar).getTL() / 100.0);
                            }
                            row[index++] = "";
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            ElexisStatus status = new ElexisStatus(4, "ch.elexis.buchhaltung.basis", 1, Messages.AlleLeistungen_TarmedMissing, 1);
                            StatusManager.getManager().handle((IStatus)status, 2);
                            return Status.CANCEL_STATUS;
                        }
                    } else {
                        row[index++] = "";
                        row[index++] = "";
                        row[index++] = "";
                    }
                    row[index++] = this.getClassName(verrechnet);
                    row[index++] = Double.valueOf(verrechnet.getTPW());
                    row[index++] = Double.valueOf((double)verrechnet.getZahl() * verrechnet.getSecondaryScaleFactor());
                    row[index++] = verrechnet.getKosten();
                    row[index++] = verrechnet.getEffPreis();
                    row[index++] = this.getSales(verrechnet);
                    row[index++] = this.getVatScale(verrechnet);
                    row[index++] = billState;
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    result.add(row);
                }
            }
            monitor.worked(step);
        }
        LoggerFactory.getLogger(AlleLeistungen.class).debug("calculation of konsultations size: " + consultations.size() + " took " + Long.valueOf((System.currentTimeMillis() - time) / 1000L) + " seconds.");
        this.dataSet.setContent(result);
        monitor.done();
        return Status.OK_STATUS;
    }

    private String[] performanceOptimization(Patient patient, Mandant mandant) {
        if (patient != null) {
            patient.get(false, new String[]{"Name", "Vorname", "Geburtsdatum", "Geschlecht", "PatientNr"});
        }
        String[] data = new String[]{"", "", "", "", ""};
        if (mandant != null) {
            data[0] = mandant.getRechnungssteller().getLabel();
            data[1] = mandant.getMandantLabel();
        }
        if (patient != null) {
            Kontakt stammArzt = patient.getStammarzt();
            if (stammArzt != null) {
                data[2] = stammArzt.getLabel();
            }
            Anschrift anschrift = patient.getAnschrift();
            data[3] = anschrift.getPlz();
            data[4] = anschrift.getOrt();
        }
        return data;
    }

    private String getClassName(Verrechnet verrechnet) {
        String fullname = verrechnet.get("Klasse");
        if (fullname != null && !fullname.isEmpty() && fullname.lastIndexOf(46) != -1) {
            return fullname.substring(fullname.lastIndexOf(46) + 1);
        }
        return "";
    }

    private Money getSales(Verrechnet verrechnet) {
        double vk_tp = 0.0;
        try {
            vk_tp = Double.parseDouble(verrechnet.get("VK_TP"));
        }
        catch (NumberFormatException numberFormatException) {}
        double vk_scale = 1.0;
        try {
            vk_scale = Double.parseDouble(verrechnet.get("VK_Scale"));
        }
        catch (NumberFormatException numberFormatException) {}
        double scale1 = verrechnet.getPrimaryScaleFactor();
        double scale2 = verrechnet.getSecondaryScaleFactor();
        return new Money((int)((double)Math.round(vk_tp * vk_scale) * scale1 * scale2 * (double)verrechnet.getZahl()));
    }

    private String getVatScale(Verrechnet verrechnet) {
        String scale = verrechnet.getDetail("vat_scale");
        if (scale != null) {
            return scale;
        }
        return "0.0";
    }

    private int getVatInfoCode(Verrechnet verrechnet) {
        String scale = this.getVatScale(verrechnet);
        if (scale != null) {
            return this.guessVatCode(scale);
        }
        return 0;
    }

    private int guessVatCode(String vatRate) {
        if (vatRate != null && !vatRate.isEmpty()) {
            double scale = Double.parseDouble(vatRate);
            if (scale == 0.0) {
                return 0;
            }
            if (scale < 7.0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

