/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.textplugin;

import ch.elexis.base.textplugin.EStyledText;
import ch.elexis.base.textplugin.ElexisEditor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class TextBox
extends EStyledText
implements PaintListener {
    public static final int MIN_SIZE = 15;
    private boolean highlight;

    public TextBox(Composite parent, ElexisEditor editor) {
        super(parent, editor, 64);
        this.setSize(200, 100);
        this.setRedraw(true);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TextBox.this.redraw();
            }
        });
        this.addPaintListener(this);
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
        this.setBackground(this.getDisplay().getSystemColor(highlight ? 15 : 1));
    }

    public void setLocation(int x, int y) {
    }

    public void forceLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void paintControl(PaintEvent e) {
        Point size = this.getSize();
        if (this.highlight && size.equals((Object)this.getSize())) {
            e.gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException {
        int x = in.readInt();
        int y = in.readInt();
        int w = in.readInt();
        int h = in.readInt();
        this.forceLocation(x, y);
        this.setSize(w, h);
        super.readFrom(in);
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeInt(this.getLocation().x);
        out.writeInt(this.getLocation().y);
        out.writeInt(this.getSize().x);
        out.writeInt(this.getSize().y);
        super.writeTo(out);
    }
}

