/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.textplugin;

import ch.elexis.base.textplugin.EStyledText;
import ch.elexis.base.textplugin.ElexisEditor;
import ch.elexis.base.textplugin.TextBox;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class Page
extends EStyledText
implements MouseListener,
MouseMoveListener,
KeyListener,
VerifyListener,
PaintObjectListener {
    private boolean altDown;
    private boolean mouseDown;
    private Point mouseScreenLoc;
    private Point mouseWidgetLoc;
    protected List<TextBox> textBoxes;
    private int state;
    private boolean highlight;
    private final List<Integer> offsets;
    private final List<Control> controls;
    private static final int STATE_NONE = 0;
    private static final int STATE_MOVE = 1;
    private static final int STATE_RESIZE_LEFT = 2;
    private static final int STATE_RESIZE_RIGHT = 3;
    private static final int STATE_RESIZE_UP = 4;
    private static final int STATE_RESIZE_DOWN = 5;
    private static final int MARGIN = 1;

    public Page(Composite parent, ElexisEditor editor) {
        super(parent, editor, 2112);
        this.setSize(602, 800);
        this.textBoxes = new ArrayList<TextBox>();
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.mouseScreenLoc = this.mouseWidgetLoc = new Point(0, 0);
        this.addVerifyListener(this);
        this.addPaintObjectListener(this);
        this.offsets = new ArrayList<Integer>();
        this.controls = new ArrayList<Control>();
    }

    public TextBox insertBox() {
        Composite comp = new Composite((Composite)this, 0);
        for (TextBox old : this.textBoxes) {
            old.setParent(comp);
        }
        TextBox box = new TextBox((Composite)this, this.editor);
        Control[] controlls = comp.getChildren();
        int i = controlls.length - 1;
        while (i >= 0) {
            controlls[i].setParent((Composite)this);
            --i;
        }
        comp.dispose();
        box.setHighlight(this.highlight);
        box.forceFocus();
        this.textBoxes.add(box);
        box.addKeyListener(this);
        box.addMouseListener(this);
        box.addMouseMoveListener(this);
        return box;
    }

    public void setHightlight(boolean b) {
        this.highlight = b;
        for (TextBox box : this.textBoxes) {
            box.setHighlight(b);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.mouseDown = true;
        this.mouseWidgetLoc = new Point(e.x, e.y);
        this.mouseScreenLoc = this.getDisplay().getCursorLocation();
    }

    public void mouseUp(MouseEvent e) {
        this.mouseDown = false;
    }

    public void mouseMove(MouseEvent e) {
        this.mouseWidgetLoc = new Point(e.x, e.y);
        Object o = e.getSource();
        Control control = (Control)o;
        if (this.mouseDown && control instanceof TextBox) {
            TextBox box = (TextBox)control;
            switch (this.state) {
                case 1: {
                    this.moveBox(box);
                    break;
                }
                case 2: {
                    this.resizeLeft(box);
                    break;
                }
                case 3: {
                    this.resizeRight(box);
                    break;
                }
                case 4: {
                    this.resizeUp(box);
                    break;
                }
                case 5: {
                    this.resizeDown(box);
                }
            }
        } else {
            this.updateState(control);
        }
    }

    private void resizeDown(TextBox box) {
        Point mouseNewLoc = this.getDisplay().getCursorLocation();
        int diff = mouseNewLoc.y - this.mouseScreenLoc.y;
        Rectangle bounds = box.getBounds();
        bounds.height += diff;
        if (bounds.height > 15 && bounds.y + bounds.height < this.getSize().y) {
            box.setBounds(bounds);
            this.mouseScreenLoc = mouseNewLoc;
        }
    }

    private void resizeUp(TextBox box) {
        Point mouseNewLoc = this.getDisplay().getCursorLocation();
        int diff = mouseNewLoc.y - this.mouseScreenLoc.y;
        Rectangle bounds = box.getBounds();
        bounds.y += diff;
        bounds.height -= diff;
        if (bounds.y > 0 && bounds.height > 15) {
            box.setBounds(bounds);
            this.mouseScreenLoc = mouseNewLoc;
        }
    }

    private void resizeRight(TextBox box) {
        Point mouseNewLoc = this.getDisplay().getCursorLocation();
        int diff = mouseNewLoc.x - this.mouseScreenLoc.x;
        Rectangle bounds = box.getBounds();
        bounds.width += diff;
        if (bounds.width > 15 && bounds.x + bounds.width < this.getSize().x) {
            box.setBounds(bounds);
            this.mouseScreenLoc = mouseNewLoc;
        }
    }

    private void resizeLeft(TextBox box) {
        Point mouseNewLoc = this.getDisplay().getCursorLocation();
        int diff = mouseNewLoc.x - this.mouseScreenLoc.x;
        Rectangle bounds = box.getBounds();
        bounds.x += diff;
        bounds.width -= diff;
        if (bounds.x > 0 && bounds.width > 15) {
            box.setBounds(bounds);
            this.mouseScreenLoc = mouseNewLoc;
        }
    }

    private void moveBox(TextBox box) {
        Point loc = box.getLocation();
        Point size = this.getSize();
        Point boxSize = box.getSize();
        Point mouseNewLoc = this.getDisplay().getCursorLocation();
        int x = Math.max(0, loc.x + mouseNewLoc.x - this.mouseScreenLoc.x);
        int y = Math.max(0, loc.y + mouseNewLoc.y - this.mouseScreenLoc.y);
        x = Math.min(size.x - boxSize.x, x);
        y = Math.min(size.y - boxSize.y, y);
        box.forceLocation(x, y);
        this.mouseScreenLoc = mouseNewLoc;
    }

    private void updateState(Control control) {
        if (this.altDown) {
            this.state = this.checkResize(control);
            if (this.state == 0) {
                this.state = 1;
            }
        } else {
            this.state = 0;
        }
        int cursor = 0;
        switch (this.state) {
            case 1: {
                cursor = 21;
                break;
            }
            case 2: 
            case 3: {
                cursor = 13;
                break;
            }
            case 4: 
            case 5: {
                cursor = 10;
            }
        }
        Cursor mouseCursor = this.getDisplay().getSystemCursor(cursor);
        for (TextBox box : this.textBoxes) {
            box.setCursor(mouseCursor);
        }
    }

    private int checkResize(Control control) {
        int diff = control.getBorderWidth() + 4;
        if (this.mouseWidgetLoc.x < diff) {
            return 2;
        }
        if (this.mouseWidgetLoc.x > control.getSize().x - 2 * diff) {
            return 3;
        }
        if (this.mouseWidgetLoc.y < diff) {
            return 4;
        }
        if (this.mouseWidgetLoc.y > control.getSize().y - 2 * diff) {
            return 5;
        }
        return 0;
    }

    public void keyPressed(KeyEvent e) {
        this.altDown = e.keyCode == 65536;
        this.updateState((Control)e.getSource());
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 65536) {
            this.altDown = false;
        }
        this.updateState((Control)e.getSource());
    }

    public void clear() {
        this.setText("");
        for (TextBox box : this.textBoxes) {
            box.dispose();
        }
        this.textBoxes.clear();
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException {
        this.clear();
        int boxesCount = in.readInt();
        super.readFrom(in);
        int i = 0;
        while (i < boxesCount) {
            TextBox box = this.editor.insertBox();
            box.readFrom(in);
            ++i;
        }
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeInt(this.textBoxes.size());
        super.writeTo(out);
        for (TextBox box : this.textBoxes) {
            box.writeTo(out);
        }
    }

    public void addTable(final Table table, final int offset) {
        this.offsets.add(offset);
        this.controls.add((Control)table);
        StyleRange style = new StyleRange();
        style.start = offset;
        style.length = 1;
        Rectangle rect = table.getBounds();
        int ascent = 2 * rect.height / 3;
        int descent = rect.height - ascent;
        style.metrics = new GlyphMetrics(ascent + 1, descent + 1, rect.width + 2);
        this.setStyleRange(style);
        table.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                int inc;
                table.getItem(new Point(event.x, event.y));
                int x = event.x;
                int index = 0;
                TableColumn column = table.getColumn(index);
                int w = column.getWidth();
                while (x > w) {
                    if (++index >= table.getColumnCount()) {
                        return;
                    }
                    column = table.getColumn(index);
                    w += column.getWidth();
                }
                int n = inc = event.count > 0 ? 5 : -5;
                if (column.getWidth() + inc < 5) {
                    return;
                }
                column.setWidth(column.getWidth() + inc);
                int rowcount = table.getItemCount();
                int columncount = table.getColumnCount();
                Rectangle rect = table.getItem(rowcount - 1).getBounds(columncount - 1);
                table.setSize(rect.x + rect.width + 5, rect.y + rect.height + 5);
                rect = table.getBounds();
                StyleRange style = new StyleRange();
                style.start = offset;
                style.length = 1;
                int ascent = 2 * rect.height / 3;
                int descent = rect.height - ascent;
                style.metrics = new GlyphMetrics(ascent + 1, descent + 1, rect.width + 2);
                Page.this.setStyleRange(style);
            }
        });
    }

    public void verifyText(VerifyEvent e) {
        int start = e.start;
        int replaceCharCount = e.end - e.start;
        int newCharCount = e.text.length();
        int index = 0;
        for (int offset : this.offsets) {
            if (start <= offset && offset < start + replaceCharCount) {
                Control control = this.controls.get(index);
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                    control = null;
                }
                offset = -1;
            }
            if (offset != -1 && offset >= start) {
                offset += newCharCount - replaceCharCount;
            }
            this.offsets.set(index, offset);
            ++index;
        }
    }

    public void paintObject(PaintObjectEvent event) {
        StyleRange style = event.style;
        int start = style.start;
        int index = 0;
        for (int offset : this.offsets) {
            if (start == offset) {
                Control control = this.controls.get(index);
                Point pt = control.getSize();
                int x = event.x + 1;
                int y = event.y + event.ascent - 2 * pt.y / 3;
                control.setLocation(x, y);
                break;
            }
            ++index;
        }
    }

    private Rectangle centerRect(Point containerSize, Point childSize) {
        int x = (containerSize.x - childSize.x) / 2;
        int y = (containerSize.y - childSize.y) / 2;
        Rectangle rect = new Rectangle(x, y, childSize.x, childSize.y);
        return rect;
    }

    public void print(Printer printer, GC gc) {
        Rectangle clientArea = printer.getClientArea();
        Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        Point dpi = printer.getDPI();
        int leftMargin = dpi.x + trim.x;
        int rightMargin = clientArea.width - dpi.x + trim.x + trim.width;
        int topMargin = dpi.y + trim.y;
        int cfr_ignored_0 = clientArea.height;
        int cfr_ignored_1 = dpi.y;
        int cfr_ignored_2 = trim.y;
        int cfr_ignored_3 = trim.height;
        int x = leftMargin;
        int ex = leftMargin;
        int y = topMargin;
        StringBuffer line = new StringBuffer();
        FontMetrics fm = gc.getFontMetrics();
        List<StyleRange> styles = this.getStyles();
        for (StyleRange style : styles) {
            gc.setFont(new Font((Device)printer, style.font.getFontData()[0].getName(), style.font.getFontData()[0].getHeight(), style.fontStyle));
            fm = gc.getFontMetrics();
            String text = this.getText(style.start, style.start + style.length - 1);
            List<String> words = this.split(text);
            Iterator<String> wit = words.iterator();
            String word = wit.hasNext() ? wit.next() : null;
            while (word != null) {
                if (word.equals("\r")) {
                    gc.drawString(line.toString(), leftMargin, y);
                    line.setLength(0);
                    x = ex = leftMargin;
                    y += fm.getHeight();
                }
                String string = word = ex == leftMargin ? word.trim() : word;
                if ((ex += gc.stringExtent((String)word).x) < rightMargin) {
                    line.append(word);
                    word = wit.hasNext() ? wit.next() : null;
                    continue;
                }
                gc.drawString(line.toString(), x, y);
                line.setLength(0);
                x = ex = leftMargin;
                y += fm.getHeight();
            }
            if (line.length() <= 0) continue;
            gc.drawString(line.toString(), x, y);
            x = ex;
            line.setLength(0);
        }
    }

    private List<String> split(String text) {
        ArrayList<String> words = new ArrayList<String>();
        String delims = " \n\r";
        boolean previosWordIsLineReturn = false;
        StringTokenizer st = new StringTokenizer(text, delims, true);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (word.equals("\n") || word.equals("\r")) {
                if (!previosWordIsLineReturn) {
                    words.add(word);
                    previosWordIsLineReturn = false;
                    continue;
                }
                previosWordIsLineReturn = true;
                continue;
            }
            words.add(word);
            previosWordIsLineReturn = false;
        }
        return words;
    }
}

