/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.textplugin;

import ch.elexis.base.textplugin.ElexisEditor;
import ch.elexis.base.textplugin.TextBox;
import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import ch.elexis.core.ui.text.ITextPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ElexisTextPlugin
implements ITextPlugin {
    private ElexisEditor editor;
    private boolean showToolbar = true;
    private ITextPlugin.PageFormat pageFormat;
    private String font;
    private int style;
    private float size;
    public static ElexisTextPlugin tempInstance;
    private ITextPlugin.Parameter textParameter = null;

    public ElexisTextPlugin() {
        tempInstance = this;
    }

    public void setParameter(ITextPlugin.Parameter parameter) {
        this.textParameter = parameter;
    }

    public boolean clear() {
        if (this.editor != null) {
            this.editor.page.clear();
        }
        return true;
    }

    public Composite createContainer(Composite parent, ITextPlugin.ICallback handler) {
        if (this.editor == null) {
            Composite composite = new Composite(parent, 0);
            GridLayout grid = new GridLayout();
            grid.numColumns = 1;
            composite.setLayout((Layout)grid);
            this.editor = new ElexisEditor(composite, handler);
            GridData spec = new GridData();
            spec.horizontalAlignment = 4;
            spec.grabExcessHorizontalSpace = true;
            spec.verticalAlignment = 4;
            spec.grabExcessVerticalSpace = true;
            this.editor.setLayoutData(spec);
            this.showToolbar(this.showToolbar);
            return composite;
        }
        return this.editor.getParent();
    }

    public boolean createEmptyDocument() {
        return this.clear();
    }

    public String getMimeType() {
        return "Mime-Type";
    }

    public boolean insertTable(String place, int properties, String[][] contents, int[] columnSizes) {
        String text;
        if (this.editor == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(place);
        Matcher matcher = pattern.matcher(text = this.editor.page.getText());
        if (!matcher.find()) {
            return false;
        }
        this.editor.insertTable(matcher.start(), matcher.end(), contents, (properties & 1) != 0, (properties & 2) != 0, this.font, (int)this.size, this.style);
        return false;
    }

    public Object insertText(String marke, final String text, int adjust) {
        if (this.editor == null) {
            return false;
        }
        return this.findOrReplace(marke, new ReplaceCallback(){

            public String replace(String in) {
                return text;
            }
        }, true);
    }

    public Object insertText(Object pos, String text, int adjust) {
        if (this.editor == null || !(pos instanceof Pos)) {
            return false;
        }
        Pos pospos = (Pos)pos;
        try {
            pospos.text.setCaretOffset(pospos.caret);
            pospos.text.insert(text);
            StyleRange original = pospos.text.getStyleRangeAtOffset(pospos.caret);
            if (original == null) {
                original = new StyleRange();
            }
            StyleRange style = (StyleRange)original.clone();
            style.start = pospos.caret;
            style.length = text.length();
            style.font = this.font != null ? new Font((Device)this.editor.getDisplay(), this.font, (int)this.size, this.style) : null;
            style.fontStyle = this.style != 0 ? this.style : style.fontStyle;
            pospos.text.setStyleRange(style);
            Pos p = new Pos();
            p.text = pospos.text;
            p.caret = pospos.caret + text.length();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return null;
    }

    public Object insertTextAt(int x, int y, int w, int h, String text, int adjust) {
        TextBox box = this.editor.insertBox(x, y, w, h);
        box.setText(text);
        return new Pos(box, text.length());
    }

    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        return false;
    }

    public boolean print(String toPrinter, String toTray, boolean waitUntilFinished) {
        return false;
    }

    public boolean setFont(String name, int style, float size) {
        this.font = name;
        this.style = style;
        this.size = size;
        return true;
    }

    public boolean setStyle(int style) {
        this.style = style;
        return true;
    }

    public void showMenu(boolean b) {
    }

    public void showToolbar(boolean b) {
        if (this.editor != null) {
            this.editor.toolBar.setVisible(b);
            GridData data = (GridData)this.editor.toolBar.getLayoutData();
            data.exclude = !b;
            this.editor.layout();
        } else {
            this.showToolbar = b;
        }
    }

    public byte[] storeToByteArray() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            this.editor.page.writeTo(out);
            bout.close();
            out.close();
            return bout.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new byte[0];
        }
    }

    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        ByteArrayInputStream bin = new ByteArrayInputStream(bs);
        DataInputStream in = new DataInputStream(bin);
        try {
            this.editor.page.readFrom(in);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean findOrReplace(String pattern, ReplaceCallback cb) {
        return this.findOrReplace(pattern, cb, false) != null;
    }

    private Pos findOrReplace(String pattern, ReplaceCallback cb, boolean firstTimeOnly) {
        if (this.editor != null) {
            Pattern regexp = Pattern.compile(pattern);
            Pos result = null;
            result = this.findOrReplace(regexp, this.editor.page, cb, firstTimeOnly);
            if (result != null && (cb == null || firstTimeOnly)) {
                return result;
            }
            for (TextBox box : this.editor.page.textBoxes) {
                result = this.findOrReplace(regexp, box, cb, firstTimeOnly);
                if (result == null || cb != null && !firstTimeOnly) continue;
                return result;
            }
            return result;
        }
        return null;
    }

    private Pos findOrReplace(Pattern pattern, StyledText styledText, ReplaceCallback callback, boolean firstTimeOnly) {
        String text = styledText.getText();
        Matcher matcher = pattern.matcher(text);
        if (!matcher.find()) {
            return null;
        }
        int diff = 0;
        do {
            int start = matcher.start();
            int end = matcher.end();
            String str = text.substring(start, end);
            if (callback != null) {
                String replace = (String)callback.replace(str);
                StyleRange style = styledText.getStyleRangeAtOffset(start + diff);
                style = (StyleRange)style.clone();
                if (firstTimeOnly) {
                    style = (StyleRange)style.clone();
                    int n = style.fontStyle = this.style != 0 ? this.style : style.fontStyle;
                    if (this.font != null) {
                        style.font = new Font((Device)this.editor.getDisplay(), this.font, (int)this.size, this.style);
                    }
                }
                styledText.replaceTextRange(start + diff, end - start, replace);
                style.start = start + diff;
                style.length = replace.length();
                styledText.setStyleRange(style);
                diff += replace.length() - end + start;
                if (!firstTimeOnly) continue;
                return new Pos(styledText, end + diff);
            }
            return new Pos(styledText, end);
        } while (matcher.find());
        return new Pos();
    }

    public ITextPlugin.PageFormat getFormat() {
        return this.pageFormat;
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.page.forceFocus();
        }
    }

    public void setFormat(ITextPlugin.PageFormat f) {
        this.pageFormat = f;
    }

    public void dispose() {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void setSaveOnFocusLost(boolean bSave) {
    }

    public boolean isDirectOutput() {
        return false;
    }

    public void initTemplatePrintSettings(String template) {
    }

    static class Pos {
        StyledText text;
        int caret;

        public Pos() {
        }

        public Pos(StyledText text, int caret) {
            this.text = text;
            this.caret = caret;
        }
    }
}

