/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.textplugin;

import ch.elexis.base.textplugin.EStyledText;
import ch.elexis.base.textplugin.ElexisTextPlugin;
import ch.elexis.base.textplugin.Page;
import ch.elexis.base.textplugin.TextBox;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.ITextPlugin;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ElexisEditor
extends Composite
implements ExtendedModifyListener {
    protected Page page;
    private boolean isBold;
    private boolean isItalic;
    private boolean isUnderline;
    private String fontName = "Arial";
    private int fontHeight = 10;
    protected ToolBar toolBar;
    private ToolItem newBoxToolItem;
    private ToolItem highlightToolItem;
    private ToolItem deleteToolItem;
    private ToolItem boldToolItem;
    private ToolItem italicToolItem;
    private ToolItem underlineToolItem;
    private ToolItem cutToolItem;
    private ToolItem copyToolItem;
    private ToolItem pasteToolItem;
    private ToolItem saveToolItem;
    private ToolItem saveAsToolItem;
    private ToolItem printToolItem;
    private Combo fontCombo;
    private Combo fontHeigtCombo;
    private final Listener caretListener;
    private StyledText lastSelectedText;
    private final Vector<StyleRange> cachedStyles = new Vector();
    private final ImageRegistry imageRegistry = UiDesk.getImageRegistry();
    private final ITextPlugin.ICallback handler;

    protected ElexisEditor(Composite parent, ITextPlugin.ICallback handler) {
        super(parent, 0);
        this.handler = handler;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.caretListener = new Listener(){

            public void handleEvent(Event event) {
                ElexisEditor.this.caretUpdate(event);
            }
        };
        this.checkImages();
        this.createToolbar();
        this.createPage();
        this.layout();
    }

    private ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.base.textplugin", (String)path);
    }

    private void checkImages() {
        if (this.imageRegistry.get("new-box") == null) {
            this.imageRegistry.put("new-box", this.getImageDescriptor("icons/new-box.gif"));
        }
        if (this.imageRegistry.get("italic") == null) {
            this.imageRegistry.put("italic", this.getImageDescriptor("icons/italic.gif"));
        }
        if (this.imageRegistry.get("bold") == null) {
            this.imageRegistry.put("bold", this.getImageDescriptor("icons/bold.gif"));
        }
        if (this.imageRegistry.get("underline") == null) {
            this.imageRegistry.put("underline", this.getImageDescriptor("icons/underline.gif"));
        }
        if (this.imageRegistry.get("font") == null) {
            this.imageRegistry.put("font", this.getImageDescriptor("icons/font.gif"));
        }
        if (this.imageRegistry.get("highlight-boxes") == null) {
            this.imageRegistry.put("highlight-boxes", this.getImageDescriptor("icons/highlight-boxes.gif"));
        }
        if (this.imageRegistry.get("delete") == null) {
            this.imageRegistry.put("delete", this.getImageDescriptor("icons/delete.gif"));
        }
        if (this.imageRegistry.get("paste") == null) {
            this.imageRegistry.put("paste", this.getImageDescriptor("icons/paste.gif"));
        }
        if (this.imageRegistry.get("copy") == null) {
            this.imageRegistry.put("copy", this.getImageDescriptor("icons/copy.gif"));
        }
        if (this.imageRegistry.get("cut") == null) {
            this.imageRegistry.put("cut", this.getImageDescriptor("icons/cut.gif"));
        }
        if (this.imageRegistry.get("save") == null) {
            this.imageRegistry.put("save", this.getImageDescriptor("icons/save.gif"));
        }
        if (this.imageRegistry.get("saveas") == null) {
            this.imageRegistry.put("saveas", this.getImageDescriptor("icons/saveas.gif"));
        }
        if (this.imageRegistry.get("print") == null) {
            this.imageRegistry.put("print", this.getImageDescriptor("icons/printer.png"));
        }
    }

    private void createPage() {
        ScrolledComposite scrollable = new ScrolledComposite((Composite)this, 2816);
        this.page = new Page((Composite)scrollable, this);
        this.page.setHightlight(true);
        this.page.forceFocus();
        this.page.addExtendedModifyListener(this);
        this.addCaretListener(this.page);
        scrollable.setContent((Control)this.page);
        GridData data = new GridData(602, 350);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        scrollable.setLayoutData((Object)data);
        this.lastSelectedText = this.page;
        this.updateControls();
    }

    private void addCaretListener(StyledText text) {
        text.addListener(3, this.caretListener);
        text.addListener(1, this.caretListener);
    }

    private void createToolbar() {
        this.toolBar = new ToolBar((Composite)this, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.toolBar.setLayoutData((Object)data);
        this.newBoxToolItem = new ToolItem(this.toolBar, 8);
        this.newBoxToolItem.setToolTipText("Insert new text-box");
        this.newBoxToolItem.setImage(this.imageRegistry.get("new-box"));
        this.deleteToolItem = new ToolItem(this.toolBar, 8);
        this.deleteToolItem.setToolTipText("Delete current text-box");
        this.deleteToolItem.setImage(this.imageRegistry.get("delete"));
        this.highlightToolItem = new ToolItem(this.toolBar, 32);
        this.highlightToolItem.setToolTipText("Highlight text-boxes");
        this.highlightToolItem.setSelection(true);
        this.highlightToolItem.setImage(this.imageRegistry.get("highlight-boxes"));
        new ToolItem(this.toolBar, 2);
        this.saveToolItem = new ToolItem(this.toolBar, 8);
        this.saveToolItem.setToolTipText("Save");
        this.saveToolItem.setImage(this.imageRegistry.get("save"));
        this.saveAsToolItem = new ToolItem(this.toolBar, 8);
        this.saveAsToolItem.setToolTipText("Save As");
        this.saveAsToolItem.setImage(this.imageRegistry.get("saveas"));
        this.printToolItem = new ToolItem(this.toolBar, 8);
        this.printToolItem.setToolTipText("Print");
        this.printToolItem.setImage(this.imageRegistry.get("print"));
        new ToolItem(this.toolBar, 2);
        this.boldToolItem = new ToolItem(this.toolBar, 32);
        this.boldToolItem.setToolTipText("Bold");
        this.boldToolItem.setImage(this.imageRegistry.get("bold"));
        this.italicToolItem = new ToolItem(this.toolBar, 32);
        this.italicToolItem.setToolTipText("Italic");
        this.italicToolItem.setImage(this.imageRegistry.get("italic"));
        this.underlineToolItem = new ToolItem(this.toolBar, 32);
        this.underlineToolItem.setToolTipText("Underline");
        this.underlineToolItem.setImage(this.imageRegistry.get("underline"));
        ToolItem sep = new ToolItem(this.toolBar, 2);
        this.fontCombo = new Combo((Composite)this.toolBar, 8);
        this.fontCombo.setToolTipText("Font");
        FontData[] fonts = this.getDisplay().getFontList(null, true);
        TreeSet<String> uniqueFonts = new TreeSet<String>();
        int i = 0;
        while (i < fonts.length) {
            FontData fd = fonts[i];
            uniqueFonts.add(fd.getName());
            ++i;
        }
        for (String name : uniqueFonts) {
            this.fontCombo.add(name);
        }
        this.fontCombo.pack();
        sep.setWidth(this.fontCombo.getSize().x);
        sep.setControl((Control)this.fontCombo);
        new ToolItem(this.toolBar, 2);
        this.fontHeigtCombo = new Combo((Composite)this.toolBar, 8);
        int[] height = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 72};
        int i2 = 0;
        while (i2 < height.length) {
            this.fontHeigtCombo.add(String.valueOf(height[i2]));
            ++i2;
        }
        this.fontHeigtCombo.pack();
        ToolItem sep2 = new ToolItem(this.toolBar, 2);
        sep2.setWidth(this.fontHeigtCombo.getSize().x);
        sep2.setControl((Control)this.fontHeigtCombo);
        new ToolItem(this.toolBar, 2);
        this.cutToolItem = new ToolItem(this.toolBar, 8);
        this.cutToolItem.setToolTipText("Cut");
        this.cutToolItem.setImage(this.imageRegistry.get("cut"));
        this.copyToolItem = new ToolItem(this.toolBar, 8);
        this.copyToolItem.setToolTipText("Copy");
        this.copyToolItem.setImage(this.imageRegistry.get("copy"));
        this.pasteToolItem = new ToolItem(this.toolBar, 8);
        this.pasteToolItem.setToolTipText("Paste");
        this.pasteToolItem.setImage(this.imageRegistry.get("paste"));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget == ElexisEditor.this.highlightToolItem) {
                    ElexisEditor.this.page.setHightlight(ElexisEditor.this.highlightToolItem.getSelection());
                } else if (e.widget == ElexisEditor.this.newBoxToolItem) {
                    ElexisEditor.this.insertBox();
                } else if (e.widget == ElexisEditor.this.deleteToolItem) {
                    ElexisEditor.this.deleteBox();
                } else if (e.widget == ElexisEditor.this.boldToolItem) {
                    ElexisEditor.this.isBold = !ElexisEditor.this.isBold;
                    ElexisEditor.this.updateStylesOnText();
                } else if (e.widget == ElexisEditor.this.italicToolItem) {
                    ElexisEditor.this.isItalic = !ElexisEditor.this.isItalic;
                    ElexisEditor.this.updateStylesOnText();
                } else if (e.widget == ElexisEditor.this.underlineToolItem) {
                    ElexisEditor.this.isUnderline = !ElexisEditor.this.isUnderline;
                    ElexisEditor.this.updateStylesOnText();
                } else if (e.widget == ElexisEditor.this.cutToolItem) {
                    ElexisEditor.this.lastSelectedText.cut();
                } else if (e.widget == ElexisEditor.this.copyToolItem) {
                    ElexisEditor.this.lastSelectedText.copy();
                    ElexisEditor.this.testInsertTable();
                } else if (e.widget == ElexisEditor.this.pasteToolItem) {
                    ElexisEditor.this.lastSelectedText.paste();
                } else if (e.widget == ElexisEditor.this.fontCombo) {
                    ElexisEditor.this.changeFont();
                } else if (e.widget == ElexisEditor.this.fontHeigtCombo) {
                    ElexisEditor.this.changeFontHeight();
                } else if (e.widget == ElexisEditor.this.saveToolItem) {
                    if (ElexisEditor.this.handler != null) {
                        ElexisEditor.this.handler.save();
                    }
                } else if (e.widget == ElexisEditor.this.saveAsToolItem) {
                    if (ElexisEditor.this.handler != null) {
                        ElexisEditor.this.handler.saveAs();
                    }
                } else if (e.widget == ElexisEditor.this.printToolItem) {
                    ElexisEditor.this.print();
                }
            }
        };
        this.highlightToolItem.addListener(13, listener);
        this.newBoxToolItem.addListener(13, listener);
        this.deleteToolItem.addListener(13, listener);
        this.boldToolItem.addListener(13, listener);
        this.italicToolItem.addListener(13, listener);
        this.underlineToolItem.addListener(13, listener);
        this.cutToolItem.addListener(13, listener);
        this.copyToolItem.addListener(13, listener);
        this.pasteToolItem.addListener(13, listener);
        this.fontCombo.addListener(13, listener);
        this.fontHeigtCombo.addListener(13, listener);
        this.saveToolItem.addListener(13, listener);
        this.saveAsToolItem.addListener(13, listener);
        this.printToolItem.addListener(13, listener);
    }

    private void testInsertTable() {
        String[][] contents = new String[][]{{"Whatever", "Chemical", "Programming"}, {"1", "Mercur", "Python"}, {"2", "Iridium", "Ruby"}, {"3", "Iron", "C++"}, {"4", "Gold", "Java"}, {"5", "Silver", "Pascal"}};
        ElexisTextPlugin.tempInstance.setFont("Verdana", 0, 13.0f);
        ElexisTextPlugin.tempInstance.insertTable("ab", 3, contents, null);
    }

    public void print() {
    }

    private void changeFont() {
        this.fontName = this.fontCombo.getItem(this.fontCombo.getSelectionIndex());
        this.updateStylesOnText();
        this.lastSelectedText.forceFocus();
    }

    private void changeFontHeight() {
        this.fontHeight = Integer.parseInt(this.fontHeigtCombo.getItem(this.fontHeigtCombo.getSelectionIndex()));
        this.updateStylesOnText();
        this.lastSelectedText.forceFocus();
    }

    protected TextBox insertBox() {
        TextBox box = this.page.insertBox();
        box.addExtendedModifyListener(this);
        this.addCaretListener(box);
        this.updateControls();
        return box;
    }

    protected void insertTable(int start, int end, String[][] contents, boolean header, boolean grid, String fontName, int fontHeight, int fontStyle) {
        Table table = new Table((Composite)this.page, 0x10000 | (grid ? 2048 : 0));
        table.setLinesVisible(grid);
        table.setHeaderVisible(false);
        int rowcount = contents.length;
        int columncount = contents[0].length;
        int i = 0;
        while (i < columncount) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(String.valueOf(i));
            ++i;
        }
        Font tableFont = table.getFont();
        if (fontName != null) {
            tableFont = new Font((Device)this.getDisplay(), fontName, fontHeight, fontStyle);
        }
        table.setFont(tableFont);
        int i2 = 0;
        while (i2 < rowcount) {
            String[] rowcontent = contents[i2];
            TableItem row = new TableItem(table, 0);
            int j = 0;
            while (j < rowcontent.length) {
                row.setText(j, rowcontent[j]);
                if (i2 == 0 && header) {
                    row.setBackground(j, this.getDisplay().getSystemColor(15));
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < columncount) {
            table.getColumn(i2).pack();
            ++i2;
        }
        table.pack();
        Rectangle rect = table.getItem(rowcount - 1).getBounds(columncount - 1);
        table.setSize(rect.x + rect.width + 5, rect.y + rect.height + 5);
        this.page.replaceTextRange(start, end - start, " ");
        this.page.addTable(table, start);
    }

    protected TextBox insertBox(int x, int y, int w, int h) {
        TextBox box = this.insertBox();
        w = Math.min(this.page.getSize().x, w);
        h = Math.min(this.page.getSize().y, h);
        x = Math.max(0, Math.min(this.page.getSize().x - w, x));
        y = Math.max(0, Math.min(this.page.getSize().y - h, y));
        box.forceLocation(x, y);
        box.setSize(w, h);
        return box;
    }

    private void deleteBox() {
        StyledText text = this.lastSelectedText;
        if (text instanceof TextBox) {
            this.page.textBoxes.remove(text);
            text.dispose();
            if (!this.page.textBoxes.isEmpty()) {
                this.page.textBoxes.get(this.page.textBoxes.size() - 1).forceFocus();
            }
            this.updateControls();
        }
    }

    public void setSelectedText(EStyledText text) {
        this.lastSelectedText = text;
    }

    private void updateStylesOnText() {
        int fontStyle = (this.isBold ? 1 : 0) | (this.isItalic ? 2 : 0);
        StyledText text = this.lastSelectedText;
        Point sel = text.getSelectionRange();
        if (sel == null || sel.y == 0) {
            return;
        }
        StyleRange style = new StyleRange();
        int i = sel.x;
        while (i < sel.x + sel.y) {
            StyleRange range = text.getStyleRangeAtOffset(i);
            style.start = i;
            style.length = 1;
            if (range != null) {
                style = (StyleRange)range.clone();
            }
            style.fontStyle = fontStyle;
            style.underline = this.isUnderline;
            style.font = new Font((Device)this.getDisplay(), this.fontName, this.fontHeight, fontStyle);
            text.setStyleRange(style);
            ++i;
        }
    }

    private void updateControls() {
        StyledText text = this.lastSelectedText;
        if (text.getCharCount() == 0) {
            return;
        }
        StyleRange style = text.getStyleRangeAtOffset(Math.max(0, text.getCaretOffset() - 1));
        if (style == null) {
            style = new StyleRange();
        }
        this.isBold = (style.fontStyle & 1) != 0;
        this.isItalic = (style.fontStyle & 2) != 0;
        this.isUnderline = style.underline;
        if (style.font != null && style.font.getFontData() != null && style.font.getFontData().length > 0) {
            FontData data = style.font.getFontData()[0];
            this.isBold = (data.getStyle() & 1) != 0;
            this.isItalic = (data.getStyle() & 2) != 0;
            this.fontName = data.getName();
            this.fontHeight = data.getHeight();
        }
        this.boldToolItem.setSelection(this.isBold);
        this.italicToolItem.setSelection(this.isItalic);
        this.underlineToolItem.setSelection(this.isUnderline);
        this.fontCombo.select(this.fontCombo.indexOf(this.fontName != null ? this.fontName : ""));
        this.fontHeigtCombo.select(this.fontHeigtCombo.indexOf(String.valueOf(this.fontHeight)));
    }

    public void caretUpdate(Event ev) {
        this.updateControls();
    }

    void handleCutCopy(StyledText text) {
        this.cachedStyles.clear();
        Point sel = text.getSelectionRange();
        int startX = sel.x;
        int i = sel.x;
        while (i <= sel.x + sel.y - 1) {
            StyleRange style = text.getStyleRangeAtOffset(i);
            if (style != null) {
                style.start -= startX;
                if (!this.cachedStyles.isEmpty()) {
                    StyleRange lastStyle = this.cachedStyles.lastElement();
                    if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                        ++lastStyle.length;
                    } else {
                        this.cachedStyles.addElement(style);
                    }
                } else {
                    this.cachedStyles.addElement(style);
                }
            }
            ++i;
        }
    }

    public void modifyText(ExtendedModifyEvent event) {
        StyledText text = (StyledText)event.widget;
        if (event.length == 0) {
            return;
        }
        if (event.length == 1 || text.getTextRange(event.start, event.length).equals(text.getLineDelimiter())) {
            int caretOffset = text.getCaretOffset() - 1;
            StyleRange style = null;
            if (caretOffset < text.getCharCount()) {
                style = text.getStyleRangeAtOffset(caretOffset);
            }
            if (style != null) {
                style = (StyleRange)style.clone();
                style.start = event.start;
                style.length = event.length;
            } else {
                style = new StyleRange(event.start, event.length, null, null, 0);
            }
            if (this.isBold) {
                style.fontStyle |= 1;
            }
            if (this.isItalic) {
                style.fontStyle |= 2;
            }
            style.underline = this.isUnderline;
            style.font = new Font((Device)this.getDisplay(), this.fontName, this.fontHeight, style.fontStyle);
            if (!style.isUnstyled()) {
                text.setStyleRange(style);
            }
        } else if (!this.cachedStyles.isEmpty()) {
            int i = 0;
            while (i < this.cachedStyles.size()) {
                StyleRange style = this.cachedStyles.elementAt(i);
                StyleRange newStyle = (StyleRange)style.clone();
                newStyle.start = style.start + event.start;
                text.setStyleRange(newStyle);
                ++i;
            }
        } else {
            text.setSelection(event.start, event.start + event.length);
            this.updateStylesOnText();
        }
        this.updateControls();
    }

    public boolean clear() {
        this.page.clear();
        return true;
    }
}

