/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.textplugin;

import ch.elexis.base.textplugin.ElexisEditor;
import ch.elexis.core.jdt.NonNull;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;

public class EStyledText
extends StyledText
implements FocusListener {
    protected ElexisEditor editor;

    public EStyledText(Composite parent, ElexisEditor editor, int style) {
        super(parent, style);
        this.editor = editor;
        this.addFocusListener(this);
    }

    public void cut() {
        this.editor.handleCutCopy(this);
        super.cut();
    }

    public void copy() {
        this.editor.handleCutCopy(this);
        super.copy();
    }

    public void focusGained(FocusEvent e) {
        this.editor.setSelectedText(this);
    }

    public void focusLost(FocusEvent e) {
    }

    public void readFrom(DataInputStream in) throws IOException {
        this.setText(in.readUTF());
        int stylesCount = in.readInt();
        int i = 0;
        while (i < stylesCount) {
            StyleRange style = new StyleRange();
            style.start = in.readInt();
            style.length = in.readInt();
            style.fontStyle = in.readInt();
            style.underline = in.readBoolean();
            boolean isFont = in.readBoolean();
            if (isFont) {
                style.font = new Font((Device)this.getDisplay(), in.readUTF(), in.readInt(), style.fontStyle);
            }
            this.setStyleRange(style);
            ++i;
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeUTF(this.getText());
        List<StyleRange> styles = this.getStyles();
        out.writeInt(styles.size());
        for (StyleRange style : styles) {
            out.writeInt(style.start);
            out.writeInt(style.length);
            out.writeInt(style.fontStyle);
            out.writeBoolean(style.underline);
            Font font = style.font;
            if (font != null && font.getFontData() != null && font.getFontData().length > 0) {
                out.writeBoolean(true);
                FontData fd = font.getFontData()[0];
                out.writeUTF(fd.getName());
                out.writeInt(fd.getHeight());
                continue;
            }
            out.writeBoolean(false);
        }
    }

    protected List<StyleRange> getStyles() {
        ArrayList<StyleRange> result = new ArrayList<StyleRange>();
        StyleRange[] styles = this.getStyleRanges();
        int index = 0;
        StyleRange current = styles.length > 0 ? styles[0] : null;
        while (index < styles.length) {
            if (++index >= styles.length) continue;
            StyleRange style = styles[index];
            if (current != null && this.sameStyle(current, style)) {
                current.length += style.length;
                continue;
            }
            result.add(current);
            current = style;
        }
        if (current != null) {
            result.add(current);
        }
        return result;
    }

    protected boolean sameStyle(@NonNull StyleRange s1, @NonNull StyleRange s2) {
        if (s1.fontStyle != s2.fontStyle || s1.underline != s2.underline) {
            return false;
        }
        if (s1.font != null && s2.font != null) {
            if (s1.font.getFontData() != null && s2.font.getFontData() != null) {
                FontData fd2;
                FontData fd1 = s1.font.getFontData().length > 0 ? s1.font.getFontData()[0] : null;
                FontData fontData = fd2 = s2.font.getFontData().length > 0 ? s2.font.getFontData()[0] : null;
                if (fd1 != null && fd2 != null) {
                    return fd1.height == fd2.height && fd1.getName().equals(fd2.getName());
                }
                return fd1 == fd2;
            }
            return s1.font.getFontData() == s2.font.getFontData();
        }
        return s1.font == s2.font;
    }
}

