/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.messages;

import ch.elexis.base.messages.MsgDetailDialog;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Query;
import ch.elexis.messages.Message;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgHeartListener
implements Heartbeat.HeartListener {
    static Logger log = LoggerFactory.getLogger(MsgHeartListener.class);
    boolean bSkip;

    public void heartbeat() {
        if (!this.bSkip && CoreHub.actUser != null) {
            Query qbe = new Query(Message.class);
            qbe.add("to", "=", CoreHub.actUser.getId());
            final List res = qbe.execute();
            if (res.size() > 0) {
                UiDesk.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MsgHeartListener.this.bSkip = true;
                        if (CoreHub.userCfg.get("messages/playsound", true)) {
                            MsgHeartListener.this.playSound();
                        }
                        new MsgDetailDialog(Hub.getActiveShell(), (Message)((Object)res.get(0))).open();
                        MsgHeartListener.this.bSkip = false;
                    }
                });
            }
        }
    }

    private void playSound() {
        try {
            AudioInputStream audioInStream;
            String soundFilePath = CoreHub.userCfg.get("messages/soundpath", "/sounds/notify_sound.wav");
            if ("/sounds/notify_sound.wav".equals(soundFilePath)) {
                URL sound = this.getClass().getResource(soundFilePath);
                audioInStream = AudioSystem.getAudioInputStream(sound);
            } else {
                File soundFile = new File(soundFilePath);
                if (!soundFile.exists()) {
                    log.warn("Sound file [" + soundFilePath + "] not found");
                    return;
                }
                audioInStream = AudioSystem.getAudioInputStream(soundFile);
            }
            DataLine.Info info = new DataLine.Info(Clip.class, audioInStream.getFormat());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInStream);
            clip.start();
        }
        catch (Exception e) {
            log.error("Could not play message sound", (Throwable)e);
            return;
        }
    }
}

