/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.messages;

import ch.elexis.base.messages.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.data.Reminder;
import ch.elexis.messages.Message;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MsgDetailDialog
extends Dialog {
    private Label lblFrom;
    private ComboViewer cbTo;
    private Text txtMessage;
    private Message incomingMsg;
    private List<Anwender> users = CoreHub.getUserList();
    private Button bOK;
    private Button bAnswer;

    MsgDetailDialog(Shell shell, Message msg) {
        super(shell);
        this.incomingMsg = msg;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(4, false));
        Label lblMessageInfo = new Label(ret, 0);
        lblMessageInfo.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        String msgLabel = this.incomingMsg == null ? new TimeTool().toString(0) : new TimeTool(this.incomingMsg.get("time")).toString(0);
        lblMessageInfo.setText(String.valueOf(Messages.MsgDetailDialog_messageDated) + msgLabel);
        new Label(ret, 0).setText(Messages.MsgDetailDialog_from);
        this.lblFrom = new Label(ret, 0);
        new Label(ret, 0).setText(Messages.MsgDetailDialog_to);
        this.cbTo = new ComboViewer(ret, 12);
        this.cbTo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cbTo.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Anwender anw1 = (Anwender)e1;
                Anwender anw2 = (Anwender)e2;
                return String.CASE_INSENSITIVE_ORDER.compare(anw1.getLabel(), anw2.getLabel());
            }
        });
        this.cbTo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Anwender anw = (Anwender)element;
                return anw.getLabel();
            }
        });
        this.cbTo.setInput(this.users);
        this.cbTo.setSelection((ISelection)new StructuredSelection((Object)this.users.get(0)));
        new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        if (this.incomingMsg != null) {
            String senderString = this.incomingMsg.getSender() != null ? this.incomingMsg.getSender().getLabel() : this.incomingMsg.getSenderString();
            this.lblFrom.setText(senderString);
            Anwender sender = null;
            for (Anwender anwender : this.users) {
                if (!this.incomingMsg.getDest().getId().equals(anwender.getId())) continue;
                sender = anwender;
                break;
            }
            if (sender != null) {
                this.cbTo.setSelection((ISelection)new StructuredSelection(sender));
            }
            this.cbTo.getCombo().setEnabled(false);
            new Label(ret, 0).setText(Messages.MsgDetailDialog_message);
            Label lblIncomingMsg = new Label(ret, 0);
            lblIncomingMsg.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)true));
            lblIncomingMsg.setText(this.incomingMsg.get("Text"));
            new Label(ret, 0).setText(Messages.MsgDetailDialog_answer);
        } else {
            this.lblFrom.setText(CoreHub.actUser.getLabel());
            new Label(ret, 0).setText(Messages.MsgDetailDialog_message);
        }
        this.txtMessage = SWTHelper.createText((Composite)ret, (int)1, (int)2048);
        this.txtMessage.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)true));
        this.txtMessage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MsgDetailDialog.this.txtMessage.getText() != null && MsgDetailDialog.this.txtMessage.getText().length() > 0) {
                    MsgDetailDialog.this.getShell().setDefaultButton(MsgDetailDialog.this.bAnswer);
                } else {
                    MsgDetailDialog.this.getShell().setDefaultButton(MsgDetailDialog.this.bOK);
                }
            }
        });
        return ret;
    }

    public void create() {
        super.create();
        if (this.incomingMsg == null) {
            this.getShell().setText(Messages.MsgDetailDialog_createMessage);
        } else {
            this.getShell().setText(Messages.MsgDetailDialog_readMessage);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String sOK = this.incomingMsg == null ? Messages.MsgDetailDialog_send : Messages.MsgDetailDialog_delete;
        this.bOK = this.createButton(parent, 0, sOK, false);
        parent.getShell().setDefaultButton(this.bOK);
        this.bAnswer = this.createButton(parent, 1025, Messages.MsgDetailDialog_reply, false);
        if (this.incomingMsg == null) {
            this.bAnswer.setEnabled(false);
        }
        this.createButton(parent, 1026, Messages.MsgDetailDialog_asReminder, false);
        this.createButton(parent, 1, Messages.MsgDetailDialog_cancel, false);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                return;
            }
            case 1025: {
                if (this.incomingMsg != null) {
                    Anwender an = this.incomingMsg.getSender();
                    new Message(an, this.txtMessage.getText());
                }
                this.okPressed();
            }
            case 1026: {
                StructuredSelection ss = (StructuredSelection)this.cbTo.getSelection();
                if (!ss.isEmpty()) {
                    Anwender anw = (Anwender)ss.getFirstElement();
                    Reminder rem = new Reminder(null, new TimeTool().toString(4), Visibility.ALWAYS, "", this.incomingMsg.get("Text"));
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)rem, Reminder.class, 1)});
                    rem.addResponsible(anw);
                }
                this.okPressed();
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        if (this.incomingMsg == null) {
            StructuredSelection ss = (StructuredSelection)this.cbTo.getSelection();
            if (!ss.isEmpty()) {
                this.incomingMsg = new Message((Anwender)ss.getFirstElement(), this.txtMessage.getText());
            }
        } else {
            this.incomingMsg.delete();
        }
        super.okPressed();
    }
}

