/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.messages;

import ch.elexis.base.messages.Messages;
import ch.elexis.core.data.activator.CoreHub;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MessagePreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String DEF_SOUND_PATH = "/sounds/notify_sound.wav";
    private Text txtSoundFilePath;
    private Button btnBrowse;
    private Button btnSoundOn;
    private Button btnAnswerAutoclear;
    private boolean soundOn = CoreHub.userCfg.get("messages/playsound", true);
    private boolean answerAutoclear;
    String soundFilePath = CoreHub.userCfg.get("messages/soundpath", "/sounds/notify_sound.wav");

    public MessagePreferences() {
        super(Messages.Prefs_Messages);
        this.answerAutoclear = CoreHub.userCfg.get("messages/answer/autoclear", false);
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(1, false));
        Group grpSound = new Group(ret, 0);
        grpSound.setLayout((Layout)new GridLayout(2, false));
        GridData gd_grpSound = new GridData(4, 4, true, false, 1, 1);
        grpSound.setLayoutData((Object)gd_grpSound);
        grpSound.setText(Messages.Prefs_SoundSettings);
        this.btnSoundOn = new Button((Composite)grpSound, 32);
        this.btnSoundOn.setText(Messages.Prefs_TurnOnSound);
        this.btnSoundOn.setSelection(this.soundOn);
        this.btnSoundOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagePreferences.this.txtSoundFilePath.setEnabled(MessagePreferences.this.btnSoundOn.getSelection());
                MessagePreferences.this.btnBrowse.setEnabled(MessagePreferences.this.btnSoundOn.getSelection());
            }
        });
        new Label((Composite)grpSound, 0);
        this.txtSoundFilePath = new Text((Composite)grpSound, 2048);
        this.txtSoundFilePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSoundFilePath.setText(this.soundFilePath);
        this.txtSoundFilePath.setEnabled(this.soundOn);
        this.btnBrowse = new Button((Composite)grpSound, 0);
        this.btnBrowse.setText(Messages.Prefs_BrowseFS);
        this.btnBrowse.setEnabled(this.soundOn);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(MessagePreferences.this.btnBrowse.getShell(), 4096);
                fd.setText(Messages.Prefs_FS_Open);
                fd.setFilterPath("C:/");
                String[] filterExt = new String[]{"*.wav"};
                fd.setFilterExtensions(filterExt);
                String filePath = fd.open();
                if (filePath != null) {
                    MessagePreferences.this.txtSoundFilePath.setText(filePath);
                }
            }
        });
        Group grpDialogConfig = new Group(ret, 0);
        grpDialogConfig.setLayout((Layout)new GridLayout(1, false));
        grpDialogConfig.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpDialogConfig.setText(Messages.Prefs_DialogSettings);
        this.btnAnswerAutoclear = new Button((Composite)grpDialogConfig, 32);
        this.btnAnswerAutoclear.setText(Messages.Prefs_btnAnswerAutoclear);
        this.btnAnswerAutoclear.setSelection(this.answerAutoclear);
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        CoreHub.userCfg.set("messages/playsound", true);
        CoreHub.userCfg.set("messages/soundpath", DEF_SOUND_PATH);
        CoreHub.userCfg.set("messages/answer/autoclear", false);
        this.btnAnswerAutoclear.setSelection(false);
        this.btnSoundOn.setSelection(true);
        this.btnBrowse.setEnabled(true);
        this.txtSoundFilePath.setEnabled(true);
        this.txtSoundFilePath.setText(CoreHub.userCfg.get("messages/soundpath", DEF_SOUND_PATH));
        super.performDefaults();
    }

    public boolean performOk() {
        CoreHub.userCfg.set("messages/playsound", this.btnSoundOn.getSelection());
        CoreHub.userCfg.set("messages/soundpath", this.txtSoundFilePath.getText());
        CoreHub.userCfg.set("messages/answer/autoclear", this.btnAnswerAutoclear.getSelection());
        CoreHub.userCfg.flush();
        return super.performOk();
    }
}

