/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.migel.ui;

import au.com.bytecode.opencsv.CSVReader;
import ch.elexis.artikel_ch.data.MiGelArtikel;
import ch.elexis.base.ch.migel.Messages;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.StringJoiner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class MiGelImporter
extends ImporterPage {
    private static final String SRC_ENCODING = "iso-8859-1";
    boolean bDelete = false;
    Button bClear;
    String mode;

    public String getTitle() {
        return "MiGeL";
    }

    public String getDescription() {
        return Messages.MiGelImporter_PleaseSelectFile;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        this.mode = Messages.MiGelImporter_ModeUpdateAdd;
        if (this.bDelete) {
            PersistentObject.getConnection().exec("DELETE FROM ARTIKEL WHERE TYP='MiGeL'");
            this.mode = Messages.MiGelImporter_ModeCreateNew;
        }
        try {
            File file = new File(this.results[0]);
            long l = file.length();
            monitor.beginTask("MiGeL Import " + this.mode, (int)l / 100);
            if (file.getName().toLowerCase().endsWith("csv")) {
                return this.importCSV(file, monitor);
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        return Status.CANCEL_STATUS;
    }

    public void collect() {
        this.bDelete = this.bClear.getSelection();
    }

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter ret = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.bClear = new Button(parent, 96);
        this.bClear.setText(Messages.MiGelImporter_ClearAllData);
        this.bClear.setSelection(true);
        this.bClear.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        return ret;
    }

    private IStatus importCSV(File file, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        String[] line;
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), SRC_ENCODING);
        CSVReader reader = new CSVReader((Reader)isr);
        monitor.subTask(Messages.MiGelImporter_ReadMigel);
        while ((line = reader.readNext()) != null) {
            String[] parts;
            if (!this.isFieldsLine(line) || line.length < 3) continue;
            StringBuilder text = new StringBuilder();
            String category = ImportFields.SUBCATEGORY.getStringValue(line);
            if (category.isEmpty()) {
                category = ImportFields.CATEGORY.getStringValue(line);
            }
            if (!category.isEmpty()) {
                text.append(StringTool.getFirstLine((String)category, (int)80, (String)"[\\n\\r]")).append(" - ");
            }
            text.append(ImportFields.NAME.getStringValue(line));
            String amount = ImportFields.AMOUNT.getStringValue(line);
            String unit = ImportFields.UNIT.getStringValue(line);
            if (amount.isEmpty() && !unit.isEmpty() && Character.isDigit(unit.charAt(0)) && (parts = unit.split(" ")) != null && parts.length > 1) {
                amount = parts[0];
                StringJoiner unitWithoutDigit = new StringJoiner(" ");
                int i = 1;
                while (i < parts.length) {
                    unitWithoutDigit.add(parts[i]);
                    ++i;
                }
                unit = unitWithoutDigit.toString();
            }
            MiGelArtikel artikel = new MiGelArtikel(ImportFields.POSNUMER.getStringValue(line), text.toString(), unit, ImportFields.PRICE.getMoneyValue(line));
            if (!amount.isEmpty()) {
                try {
                    double amountDbl = Double.parseDouble(amount);
                    artikel.setPackungsGroesse((int)amountDbl);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            monitor.worked(1);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean isFieldsLine(String[] line) {
        return this.containsDigits(line[0]);
    }

    private boolean containsDigits(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (Character.isDigit(character)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static enum ImportFields {
        POSNUMER(0),
        NAME(1),
        UNIT(2),
        PRICE(3),
        CATEGORY(4),
        SUBCATEGORY(5),
        AMOUNT(6);

        private int index;

        private ImportFields(int index) {
            this.index = index;
        }

        private boolean exists(String[] line) {
            return line.length > this.index;
        }

        public String getStringValue(String[] line) {
            if (this.exists(line)) {
                if (this == NAME && line[this.index].contains("\n")) {
                    line[this.index] = this.getJoinedFirstLines(line[this.index]);
                }
                return line[this.index];
            }
            return "";
        }

        private String getJoinedFirstLines(String string) {
            String[] parts = string.split("\n");
            if (parts.length > 1) {
                StringBuilder ret = new StringBuilder();
                if (!parts[1].isEmpty()) {
                    if (parts[0].endsWith(",")) {
                        ret.append(String.valueOf(parts[0]) + " " + parts[1]);
                    } else {
                        ret.append(String.valueOf(parts[0]) + ", " + parts[1]);
                    }
                } else {
                    ret.append(String.valueOf(parts[0]) + "\n");
                }
                StringJoiner rest = new StringJoiner("\n");
                int i = 2;
                while (i < parts.length) {
                    rest.add(parts[i]);
                    ++i;
                }
                if (rest.length() > 0) {
                    ret.append("\n").append(rest);
                }
                return ret.toString();
            }
            return string;
        }

        public Money getMoneyValue(String[] line) {
            if (this.exists(line)) {
                try {
                    return new Money(this.getStringValue(line));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return new Money();
        }
    }
}

