/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.migel.ui;

import ch.elexis.artikel_ch.data.MiGelArtikel;
import ch.elexis.base.ch.migel.Messages;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.rgw.tools.Money;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MiGelDetailDisplay
implements IDetailDisplay {
    FormToolkit tk = UiDesk.getToolkit();
    ScrolledForm form;
    LabeledInputField ifName;
    LabeledInputField ifPreis;
    LabeledInputField ifAmount;
    LabeledInputField ifEinheit;
    Text tName;
    Text tLong;
    MiGelArtikel act;

    public Composite createDisplay(Composite parent, IViewSite site) {
        parent.setLayout((Layout)new GridLayout());
        this.form = this.tk.createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite ret = this.form.getBody();
        ret.setLayout((Layout)new GridLayout());
        this.ifName = new LabeledInputField(ret, "Name");
        this.ifName.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tName = (Text)this.ifName.getControl();
        this.tName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (MiGelDetailDisplay.this.act != null) {
                    MiGelDetailDisplay.this.act.setInternalName(MiGelDetailDisplay.this.tName.getText());
                }
                super.focusLost(e);
            }
        });
        this.ifPreis = new LabeledInputField(ret, Messages.MiGelDetailDisplay_Price);
        this.ifAmount = new LabeledInputField(ret, Messages.MiGelDetailDisplay_Amount);
        this.ifEinheit = new LabeledInputField(ret, Messages.MiGelDetailDisplay_Unit);
        this.tLong = SWTHelper.createText((FormToolkit)this.tk, (Composite)ret, (int)4, (int)8);
        return ret;
    }

    public Class getElementClass() {
        return MiGelArtikel.class;
    }

    public void display(Object obj) {
        if (obj instanceof MiGelArtikel) {
            this.act = (MiGelArtikel)((Object)obj);
            this.form.setText(this.act.getLabel());
            this.ifName.setText(this.act.getInternalName());
            this.ifPreis.setText(new Money(this.act.getVKPreis()).getAmountAsString());
            this.ifAmount.setText(Integer.toString(this.act.getPackungsGroesse()));
            this.ifEinheit.setText(this.act.getExt("unit"));
            this.tLong.setText(this.act.getExt("FullText"));
        }
    }

    public String getTitle() {
        return "MiGeL";
    }
}

