/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.artikel_ch.data;

import ch.elexis.data.Artikel;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiGelArtikel
extends Artikel {
    public static final String MIGEL_NAME = "MiGeL";
    static Pattern pattern = Pattern.compile("([a-z0-9A-Z])([A-Z][a-z])");

    public MiGelArtikel(String code, String text, String unit, Money price) {
        this.create(MIGEL_NAME + code);
        String shortname = StringTool.getFirstLine((String)text, (int)120, (String)"[\\n\\r]");
        Matcher matcher = pattern.matcher(shortname);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, String.valueOf(matcher.group(1)) + " " + matcher.group(2));
        }
        matcher.appendTail(sb);
        shortname = sb.toString();
        this.set(new String[]{"Name", "Typ", "SubID", "Klasse"}, new String[]{shortname, MIGEL_NAME, code, MiGelArtikel.class.getName()});
        this.setExt("FullText", text);
        this.setExt("unit", unit == null ? "-" : unit);
        this.set("VK_Preis", price.getCentsAsString());
    }

    protected String getConstraint() {
        return "Typ='MiGeL'";
    }

    protected void setConstraint() {
        this.set("Typ", MIGEL_NAME);
    }

    public String getLabel() {
        return String.valueOf(this.getCode()) + " " + this.get("Name");
    }

    public String getCode() {
        return MiGelArtikel.checkNull((Object)this.get("SubID"));
    }

    public String getCodeSystemName() {
        return MIGEL_NAME;
    }

    public static MiGelArtikel load(String id) {
        return new MiGelArtikel(id);
    }

    protected MiGelArtikel(String id) {
        super(id);
    }

    protected MiGelArtikel() {
    }

    public boolean isDragOK() {
        return true;
    }
}

