/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.medikamente.bag.data;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.medikamente.bag.data.BAGMedi;
import ch.elexis.medikamente.bag.data.Interaction;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Substance
extends PersistentObject {
    public static final String TABLENAME = "CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE";
    static final String VERSION = "0.3.0";
    static final String createDB = "CREATE TABLE CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE(ID\t\tVARCHAR(25) primary key,lastupdate\tBIGINT,deleted\tCHAR(1) default '0',gruppe\tVARCHAR(10),name\t\tVARCHAR(254));CREATE INDEX CEMBS1 ON CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE (gruppe);CREATE INDEX CEMBS2 ON CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE (name);INSERT INTO CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE (ID,name) VALUES ('VERSION','0.3.0');";
    private static final String UPD020 = "ALTER TABLE CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE MODIFY gruppe VARCHAR(10); ALTER TABLE CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE MODIFY name VARCHAR(250);";
    private static final String UPD030 = "ALTER TABLE CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE ADD lastupdate BIGINT;";

    static {
        Substance.addMapping((String)TABLENAME, (String[])new String[]{"name", "gruppe", "medis=JOINT:product:substance:CH_ELEXIS_MEDIKAMENTE_BAG_JOINT", "interactions=JOINT:Subst1:Subst2:CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS"});
        Substance v = Substance.load("VERSION");
        if (v.state() < 2) {
            Substance.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(v.get("name"));
            if (vi.isOlder(VERSION)) {
                if (vi.isOlder("0.1.0")) {
                    SWTHelper.showError((String)"Datenbank Fehler", (String)"Tabelle Substance ist zu alt");
                }
                if (vi.isOlder("0.2.0")) {
                    Substance.createOrModifyTable((String)UPD020);
                }
                if (vi.isOlder(VERSION)) {
                    Substance.createOrModifyTable((String)UPD030);
                }
                v.set("name", VERSION);
            }
        }
    }

    public String getLabel() {
        return this.get("name");
    }

    public Substance(String name, String group) {
        this.create(null);
        this.set(new String[]{"name", "gruppe"}, new String[]{StringTool.limitLength((String)name, (int)250), group});
    }

    public SortedSet<BAGMedi> findMedis(SortedSet<BAGMedi> list) {
        if (list == null) {
            list = new TreeSet<BAGMedi>();
        }
        List lMedis = this.getList("medis", new String[0]);
        for (String[] r : lMedis) {
            BAGMedi bm = BAGMedi.load(r[0]);
            list.add(bm);
        }
        return list;
    }

    public List<Substance> sameGroup() {
        return Substance.allFromGroup(this.get("gruppe"));
    }

    public static Substance find(String name) {
        String id = new Query(Substance.class).findSingle("name", "=", name);
        if (id != null) {
            return Substance.load(id);
        }
        return null;
    }

    public static List<Substance> allFromGroup(String group) {
        return new Query(Substance.class, "gruppe", group).execute();
    }

    public List<Interaction> getInteractions() {
        return Interaction.getInteractionsFor(this);
    }

    public Collection<Interaction> getInteractionsWith(Substance other, SortedSet<Interaction> old) {
        if (old == null) {
            old = new TreeSet<Interaction>();
        }
        Query qbe = new Query(Interaction.class);
        qbe.startGroup();
        qbe.add("Subst1", "=", this.getId());
        qbe.add("Subst2", "=", other.getId());
        qbe.endGroup();
        qbe.or();
        qbe.startGroup();
        qbe.add("Subst1", "=", other.getId());
        qbe.and();
        qbe.add("Subst2", "=", this.getId());
        qbe.endGroup();
        return qbe.execute(old);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Substance load(String id) {
        return new Substance(id);
    }

    protected Substance() {
    }

    protected Substance(String id) {
        super(id);
    }
}

