/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.medikamente.bag.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.medikamente.bag.data.Substance;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.List;

public class Interaction
extends PersistentObject
implements Comparable<Interaction> {
    static final String TABLENAME = "CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS";
    static final String VERSION = "0.2.1";
    static final String createDB = "CREATE TABLE CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS (ID\t\t\tVARCHAR(25)\tprimary key,deleted\t\tCHAR(1) default '0',Subst1\t\tVARCHAR(25),Subst2\t\tVARCHAR(25),Type\t\t\tVARCHAR(20),Relevance\t\t\tCHAR(1),Contributor\tVARCHAR(25),ContribDate\t\tCHAR(8),Description\t\tTEXT);INSERT INTO CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS(ID,Type) VALUES ('VERSION','0.2.1');CREATE INDEX CEMBI1 ON CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS (Subst1);CREATE INDEX CEMBI2 ON CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS (Subst2);";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PLUS = 1;
    public static final int TYPE_MINUS = 2;
    public static final int TYPE_TOXIC = 3;
    public static final int TYPE_HWZ = 4;
    public static final int RELEVANCE_UNKNOWN = 0;
    public static final int RELEVANCE_LOW = 1;
    public static final int RELEVANCE_MEDIUM = 2;
    public static final int RELEVANCE_HIGH = 3;
    public static final String[] INTERAKTIONSTYPEN = new String[]{"unbekannt", "Wirkungsverst\u00e4rkung", "Wirkungsabschw\u00e4chung", "Toxizit\u00e4t", "Halbwertszeit"};
    public static final String[] RELEVANCE = new String[]{"unbekannt", "gering", "m\u00e4ssig", "hoch"};

    static {
        Interaction.addMapping((String)TABLENAME, (String[])new String[]{"Subst1", "Subst2", "Type", "Relevance", "Description", "Contributor", "ContribDate=S:D:ContribDate"});
        Interaction v = Interaction.load("VERSION");
        if (v.state() < 2) {
            Interaction.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(v.get("Type"));
            if (vi.isOlder(VERSION)) {
                if (vi.isOlder(VERSION)) {
                    Interaction.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS ADD Contributor VARCHAR(25); ALTER TABLE CH_ELEXIS_MEDIKAMENTE_BAG_INTERACTIONS ADD ContribDate CHAR(8);");
                    v.set("Type", VERSION);
                } else {
                    SWTHelper.showError((String)"Datenbank Fehler", (String)"Tabelle Interactions ist zu alt");
                }
            }
        }
    }

    public Interaction(Substance s1, Substance s2, String desc, int t, int sev) {
        this.create(null);
        this.set(new String[]{"Subst1", "Subst2", "Description", "Type", "Relevance", "Contributor", "ContribDate"}, new String[]{s1.getId(), s2.getId(), desc, Integer.toString(t), Integer.toString(sev), CoreHub.actMandant.getId(), new TimeTool().toString(4)});
    }

    public static List<Interaction> getInteractionsFor(Substance s) {
        Query qbe = new Query(Interaction.class);
        qbe.add("Subst1", "=", s.getId());
        qbe.or();
        qbe.add("Subst2", "=", s.getId());
        return qbe.execute();
    }

    public Substance[] getSubstances() {
        Substance[] ret = new Substance[]{Substance.load(this.get("Subst1")), Substance.load(this.get("Subst2"))};
        return ret;
    }

    public String getDescription() {
        String description = this.get("Description");
        return StringTool.isNothing((Object)description) ? "-" : description;
    }

    public void setDescription(String desc) {
        this.set("Description", desc);
    }

    public int getType() {
        return Interaction.checkZero((Object)this.get("Type"));
    }

    public void setType(int typ) {
        this.set("Type", Integer.toString(typ));
    }

    public int getRelevance() {
        return Interaction.checkZero((Object)this.get("Relevance"));
    }

    public void setRelevance(int r) {
        this.set("Relevance", Integer.toString(r));
    }

    public String getLabel() {
        String second;
        Substance[] s = this.getSubstances();
        StringBuilder sb = new StringBuilder();
        String first = s[0].getLabel();
        if (first.compareTo(second = s[1].getLabel()) > 0) {
            sb.append(second).append(" <-> ").append(first);
        } else {
            sb.append(first).append(" <-> ").append(second);
        }
        int type = this.getType();
        if (type > 0) {
            sb.append(": ").append(INTERAKTIONSTYPEN[this.getType()]).append(" (Relevanz: ").append(RELEVANCE[this.getRelevance()]).append(")");
        }
        return sb.toString();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Interaction load(String id) {
        return new Interaction(id);
    }

    protected Interaction(String id) {
        super(id);
    }

    protected Interaction() {
    }

    @Override
    public int compareTo(Interaction o) {
        return this.getLabel().compareTo(o.getLabel());
    }
}

