/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.medikamente.bag.data;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.medikamente.bag.data.BAGMedi;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

public class BAGMediImporter
extends ImporterPage {
    static Query<Artikel> qbe = new Query(Artikel.class);
    static Logger log = Logger.getLogger(BAGMediImporter.class.getName());

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter fbi = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        fbi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return fbi;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        FileInputStream is = new FileInputStream(this.results[0]);
        return this.doImport(is, monitor);
    }

    public IStatus doImport(InputStream inputStream, IProgressMonitor monitor) throws ElexisException {
        ExcelWrapper ew = new ExcelWrapper();
        if (ew.load(inputStream, 0)) {
            int f = ew.getFirstRow() + 1;
            int l = ew.getLastRow();
            monitor.beginTask("Import BAG-Medikamente", l - f);
            int counter = 0;
            ew.setFieldTypes(new Class[]{String.class, Character.class, Integer.class, Integer.class, Integer.class, Character.class, String.class, String.class, Double.class, Double.class, String.class, Integer.class, Integer.class, String.class, Integer.class, Character.class, String.class, String.class});
            int i = f;
            while (i < l) {
                List row = ew.getRow(i);
                monitor.subTask((String)row.get(7));
                BAGMediImporter.importUpdate(row.toArray(new String[0]));
                if (counter++ > 200) {
                    PersistentObject.clearCache();
                    counter = 0;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                row = null;
                ++i;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public static boolean importUpdate(String[] row) throws ElexisException {
        String sql;
        String pharmacode = "0";
        String ean = "";
        String atc = "";
        BAGMedi imp = null;
        if (StringTool.isNothing((Object)row[2].trim())) {
            String mid = qbe.findOne("Name", "=", row[7]);
            if (mid != null) {
                imp = BAGMedi.load(mid);
            }
        } else {
            try {
                int pcode = Integer.parseInt(row[2].trim());
                pharmacode = Integer.toString(pcode);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                log.log(Level.WARNING, "Pharmacode falsch: " + row[2]);
            }
            qbe.clear(true);
            qbe.add("SubID", "=", pharmacode);
            qbe.or();
            qbe.add("SubID", "=", row[2].trim());
            List lArt = qbe.execute();
            if (lArt == null) {
                throw new ElexisException(BAGMediImporter.class, "Article list was null while scanning for " + pharmacode, 3, true);
            }
            if (lArt.size() > 1) {
                Iterator it = lArt.iterator();
                boolean hasValid = false;
                Artikel res = null;
                while (it.hasNext()) {
                    Artikel ax = (Artikel)it.next();
                    if (hasValid || !ax.isValid()) {
                        if (res == null) {
                            res = ax;
                        }
                        it.remove();
                        continue;
                    }
                    hasValid = true;
                }
                if (!hasValid && res != null && res.isDeleted()) {
                    res.undelete();
                    lArt.add(res);
                }
            }
            imp = lArt.size() > 0 ? BAGMedi.load(((Artikel)lArt.get(0)).getId()) : null;
        }
        ean = row[16].replaceAll("'", "");
        atc = row[17];
        if (imp == null || !imp.isValid()) {
            imp = new BAGMedi(row[7], pharmacode, ean, atc);
            sql = "INSERT INTO " + "CH_ELEXIS_MEDIKAMENTE_BAG_EXT" + " (ID) VALUES (" + imp.getWrappedId() + ");";
            PersistentObject.getConnection().exec(sql);
        } else {
            sql = "SELECT ID FROM " + "CH_ELEXIS_MEDIKAMENTE_BAG_EXT" + " WHERE ID=" + imp.getWrappedId();
            String extid = PersistentObject.getConnection().queryString(sql);
            if (extid == null) {
                sql = "INSERT INTO " + "CH_ELEXIS_MEDIKAMENTE_BAG_EXT" + " (ID) VALUES (" + imp.getWrappedId() + ");";
                PersistentObject.getConnection().exec(sql);
            }
        }
        imp.update(row);
        return true;
    }

    public String getDescription() {
        return "Import Medikamentenliste BAG";
    }

    public String getTitle() {
        return "Medi-BAG";
    }
}

