/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.medikamente.bag.data;

import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Artikel;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import ch.elexis.medikamente.bag.data.BAGMediFactory;
import ch.elexis.medikamente.bag.data.BAGOptifier;
import ch.elexis.medikamente.bag.data.Interaction;
import ch.elexis.medikamente.bag.data.Substance;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class BAGMedi
extends Artikel
implements Comparable<BAGMedi> {
    public static final String EXTTABLE = "CH_ELEXIS_MEDIKAMENTE_BAG_EXT";
    public static final String JOINTTABLE = "CH_ELEXIS_MEDIKAMENTE_BAG_JOINT";
    static final String VERSION = "0.1.2";
    public static final String IMG_GENERIKUM = "ch.elexis.medikamente.bag.generikum";
    public static final String IMG_HAS_GENERIKA = "ch.elexis.medikamente.bag.has_generika";
    public static final String IMG_ORIGINAL = "ch.elexis.medikamente.bag.original";
    static final IOptifier bagOptifier = new BAGOptifier();
    static final String extDB = "CREATE TABLE CH_ELEXIS_MEDIKAMENTE_BAG_EXT (ID\t\t\t\tVARCHAR(25) primary key,lastupdate BIGINT,deleted\t\t\tCHAR(1) default '0',keywords\t\t\tVARCHAR(80),prescription\t\tTEXT,KompendiumText\tTEXT);";
    static final String jointDB = "CREATE TABLE CH_ELEXIS_MEDIKAMENTE_BAG_JOINT(ID\t\t\t\tVARCHAR(25) primary key,product\t\t\tVARCHAR(25),substance         VARCHAR(25));CREATE INDEX CHEMBJ1 ON CH_ELEXIS_MEDIKAMENTE_BAG_JOINT (product);CREATE INDEX CHEMBJ2 ON CH_ELEXIS_MEDIKAMENTE_BAG_JOINT (substance);INSERT INTO CH_ELEXIS_MEDIKAMENTE_BAG_JOINT (ID,substance) VALUES('VERSION','0.1.2');";
    public static final String CODESYSTEMNAME = "Medikament";
    public static final String DOMAIN_PHARMACODE = "www.xid.ch/id/pk";

    static {
        BAGMedi.addMapping((String)"ARTIKEL", (String[])new String[]{"Gruppe=ExtId", "Generikum=Codeclass", "inhalt=JOINT:substance:product:CH_ELEXIS_MEDIKAMENTE_BAG_JOINT", "keywords=EXT:CH_ELEXIS_MEDIKAMENTE_BAG_EXT:keywords", "prescription=EXT:CH_ELEXIS_MEDIKAMENTE_BAG_EXT:prescription", "KompendiumText=EXT:CH_ELEXIS_MEDIKAMENTE_BAG_EXT:KompendiumText"});
        Xid.localRegisterXIDDomainIfNotExists((String)DOMAIN_PHARMACODE, (String)"Pharmacode", (int)2);
        if (!BAGMedi.tableExists((String)JOINTTABLE)) {
            BAGMedi.createOrModifyTable((String)jointDB);
            BAGMedi.createOrModifyTable((String)extDB);
        } else {
            String v = BAGMedi.getConnection().queryString("SELECT substance FROM CH_ELEXIS_MEDIKAMENTE_BAG_JOINT WHERE ID='VERSION';");
            VersionInfo vi = new VersionInfo(v);
            if (vi.isOlder(VERSION)) {
                if (vi.isOlder("0.1.1")) {
                    BAGMedi.createOrModifyTable((String)extDB);
                }
                if (vi.isOlder(VERSION)) {
                    BAGMedi.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_MEDIKAMENTE_BAG_EXT add lastupdate BIGINT;");
                }
                BAGMedi.getConnection().exec("UPDATE CH_ELEXIS_MEDIKAMENTE_BAG_JOINT SET substance='0.1.2' WHERE ID='VERSION';");
            }
        }
        Substance.load("VERSION");
        String imgroot = "icons" + File.separator;
        UiDesk.getImageRegistry().put(IMG_GENERIKUM, BAGMediFactory.loadImageDescriptor(String.valueOf(imgroot) + "ggruen.png"));
        UiDesk.getImageRegistry().put(IMG_HAS_GENERIKA, BAGMediFactory.loadImageDescriptor(String.valueOf(imgroot) + "orot.png"));
        UiDesk.getImageRegistry().put(IMG_ORIGINAL, BAGMediFactory.loadImageDescriptor(String.valueOf(imgroot) + "oblau.ico"));
    }

    public BAGMedi(String name, String pharmacode, String EAN, String ATC) {
        super(name, CODESYSTEMNAME, pharmacode);
        this.set(new String[]{"Klasse", "EAN", "ATC_code"}, new String[]{this.getClass().getName(), EAN, ATC});
    }

    public boolean isGenericum() {
        return BAGMedi.checkNull((Object)this.get("Generikum")).startsWith("G");
    }

    public boolean hasGenerica() {
        return this.get("Generikum").startsWith("O");
    }

    public List<Substance> getSubstances() {
        List cnt = this.getList("inhalt", new String[0]);
        ArrayList<Substance> ret = new ArrayList<Substance>(cnt.size());
        for (String[] s : cnt) {
            ret.add(Substance.load(s[0]));
        }
        return ret;
    }

    public SortedSet<Interaction> getInteraktionen() {
        List<Substance> substances = this.getSubstances();
        TreeSet<Interaction> ret = new TreeSet<Interaction>();
        for (Substance s : substances) {
            List<Interaction> interactions = s.getInteractions();
            ret.addAll(interactions);
        }
        return ret;
    }

    public SortedSet<Interaction> getInteraktionenMit(BAGMedi other) {
        List<Substance> ls1 = this.getSubstances();
        List<Substance> ls2 = other.getSubstances();
        SortedSet<Interaction> ret = new TreeSet<Interaction>();
        for (Substance s1 : ls1) {
            if (ls2.contains((Object)s1)) continue;
            for (Substance s2 : ls2) {
                ret = (SortedSet)s1.getInteractionsWith(s2, ret);
            }
        }
        return ret;
    }

    public Kontakt getHersteller() {
        return Kontakt.load((String)this.getExt("HerstellerID"));
    }

    public void update(String[] row) {
        Query qo = new Query(Organisation.class);
        String id = qo.findSingle("Name", "=", row[0]);
        if (id == null) {
            Organisation o = new Organisation(row[0], "Pharma");
            id = o.getId();
        }
        Map exi = this.getMap("ExtInfo");
        exi.put("HerstellerID", id);
        this.set("Generikum", row[1]);
        exi.put("Pharmacode", row[2]);
        exi.put("BAG-Dossier", row[3]);
        exi.put("Swissmedic-Nr.", row[4]);
        exi.put("Swissmedic-Liste", row[5]);
        exi.put("Kassentyp", "1");
        try {
            this.setEKPreis(new Money(Double.parseDouble(row[8])));
        }
        catch (NumberFormatException numberFormatException) {
            this.setEKPreis(new Money());
            log.warn("Parse error preis " + row[7] + ": " + row[8] + "/" + row[9]);
        }
        try {
            this.setVKPreis(new Money(Double.parseDouble(row[9])));
        }
        catch (NumberFormatException numberFormatException) {
            this.setVKPreis(new Money());
            log.warn("Parse error preis " + row[7] + ": " + row[8] + "/" + row[9]);
        }
        if (row[10].equals("Y")) {
            exi.put("Limitatio", "Y");
            exi.put("LimitatioPts", row[11]);
        } else {
            exi.remove("Limitation");
        }
        if (row.length > 17 && !StringTool.isNothing((Object)row[17])) {
            this.set("ATC_code", row[17]);
        }
        if (row.length > 16 && !StringTool.isNothing((Object)row[16])) {
            this.set("EAN", row[16].replaceAll("'", ""));
        }
        if (row.length > 13 && !StringTool.isNothing((Object)row[13])) {
            String[] substName = row[13].split("\\|");
            LinkedList<Substance> substances = new LinkedList<Substance>();
            String[] stringArray = substName;
            int n = substName.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                Substance s = Substance.find(n3);
                if (s == null) {
                    s = new Substance(n3, row[12]);
                }
                substances.add(s);
                ++n2;
            }
            this.deleteList("inhalt");
            for (Substance s : substances) {
                this.addToList("inhalt", s.getId(), new String[0]);
                s = null;
            }
            substances = null;
        }
        if (row.length > 12) {
            this.set("Gruppe", row[12]);
        }
        this.setMap("ExtInfo", exi);
    }

    protected String getConstraint() {
        return "Typ='Medikament'";
    }

    protected void setConstraint() {
        this.set("Typ", CODESYSTEMNAME);
    }

    public String getCodeSystemName() {
        return CODESYSTEMNAME;
    }

    public String getCodeSystemCode() {
        String gtin = this.getEAN();
        if (gtin != null && gtin.length() > 3) {
            return "402";
        }
        return "400";
    }

    public String getCode() {
        String gtin = this.getEAN();
        if (gtin != null && gtin.length() > 3) {
            return gtin;
        }
        return this.getPharmaCode();
    }

    public static BAGMedi load(String id) {
        return new BAGMedi(id);
    }

    protected BAGMedi(String id) {
        super(id);
    }

    protected BAGMedi() {
    }

    @Override
    public int compareTo(BAGMedi arg0) {
        return this.getLabel().compareTo(arg0.getLabel());
    }

    public boolean isDragOK() {
        return true;
    }

    public boolean delete() {
        String sql = "UPDATE CH_ELEXIS_MEDIKAMENTE_BAG_EXT SET deleted='1' WHERE ID=" + this.getWrappedId();
        BAGMedi.getConnection().exec(sql);
        return super.delete();
    }

    public IOptifier getOptifier() {
        return bagOptifier;
    }
}

