/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.medikamente.bag.views;

import ch.elexis.base.ch.medikamente.bag.views.SubstanzSelektor;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.medikamente.bag.data.BAGMedi;
import ch.elexis.medikamente.bag.data.Interaction;
import ch.elexis.medikamente.bag.data.Substance;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InteraktionsDialog
extends TitleAreaDialog {
    BAGMedi medi;
    List<Substance> substances;
    Substance actSubstance;
    ListDisplay<Interaction> ldInter;
    List<Interaction> actInteractions;
    Combo cbTyp;
    Combo cbSeverity;
    Text text;
    org.eclipse.swt.widgets.List lSubst;

    public InteraktionsDialog(Shell shell, BAGMedi medi) {
        super(shell);
        this.medi = medi;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        this.substances = this.medi.getSubstances();
        new Label(ret, 0).setText("Inhaltsstoffe");
        this.lSubst = new org.eclipse.swt.widgets.List(ret, 4);
        this.lSubst.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        for (Substance s : this.substances) {
            this.lSubst.add(s.getLabel());
        }
        this.lSubst.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = InteraktionsDialog.this.lSubst.getSelectionIndex();
                if (idx != -1) {
                    InteraktionsDialog.this.setSubst(InteraktionsDialog.this.substances.get(idx));
                }
            }
        });
        new Label(ret, 0).setText("Interaktion mit:");
        this.ldInter = new ListDisplay(ret, 0, new ListDisplay.LDListener(){

            public String getLabel(Object o) {
                if (o instanceof Interaction) {
                    Interaction subst = (Interaction)o;
                    Substance[] s = subst.getSubstances();
                    if (s[0].equals((Object)InteraktionsDialog.this.actSubstance)) {
                        return s[1].getLabel();
                    }
                    return s[2].getLabel();
                }
                return "?";
            }

            public void hyperlinkActivated(String l) {
                SubstanzSelektor ssel = new SubstanzSelektor(InteraktionsDialog.this.getShell());
                if (ssel.open() == 0) {
                    Interaction iac = new Interaction(InteraktionsDialog.this.actSubstance, ssel.result, "", 0, 0);
                    InteraktionsDialog.this.ldInter.add((Object)iac);
                }
            }
        });
        this.ldInter.addHyperlinks(new String[]{"Substanz Hinzuf\u00fcgen..."});
        this.ldInter.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.ldInter.addListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteraktionsDialog.this.setInter((Interaction)InteraktionsDialog.this.ldInter.getSelection());
            }
        });
        new Label(ret, 0).setText("Typ der Interaktion");
        this.cbTyp = new Combo(ret, 12);
        this.cbTyp.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbTyp.setItems(Interaction.INTERAKTIONSTYPEN);
        this.cbTyp.select(0);
        this.cbTyp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Interaction act = (Interaction)InteraktionsDialog.this.ldInter.getSelection();
                act.setType(InteraktionsDialog.this.cbTyp.getSelectionIndex());
            }
        });
        new Label(ret, 0).setText("Klinische Relevanz");
        this.cbSeverity = new Combo(ret, 12);
        this.cbSeverity.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbSeverity.setItems(Interaction.RELEVANCE);
        this.cbSeverity.select(0);
        this.cbSeverity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Interaction act = (Interaction)InteraktionsDialog.this.ldInter.getSelection();
                act.setRelevance(InteraktionsDialog.this.cbSeverity.getSelectionIndex());
            }
        });
        new Label(ret, 0).setText("Beschreibung der Interaktion");
        this.text = SWTHelper.createText((Composite)ret, (int)4, (int)2048);
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Interaction act = (Interaction)InteraktionsDialog.this.ldInter.getSelection();
                if (act != null) {
                    act.setDescription(InteraktionsDialog.this.text.getText());
                }
                super.focusLost(e);
            }
        });
        this.setSubst(null);
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(this.medi.getLabel());
        this.getShell().setText("Interaktionen");
    }

    void setSubst(Substance s) {
        this.actSubstance = s;
        this.ldInter.clear();
        if (s != null) {
            this.actInteractions = this.actSubstance.getInteractions();
            for (Interaction inter : this.actInteractions) {
                this.ldInter.add((Object)inter);
            }
            if (this.actInteractions.size() > 0) {
                this.setInter(this.actInteractions.get(0));
            } else {
                this.setInter(null);
            }
        } else {
            this.setInter(null);
        }
    }

    void setInter(Interaction i) {
        boolean bEnable;
        if (i == null) {
            this.text.setText("");
            this.cbTyp.select(0);
            this.cbSeverity.select(0);
            bEnable = false;
        } else {
            this.text.setText(i.getDescription());
            this.cbTyp.select(i.getType());
            this.cbSeverity.select(i.getRelevance());
            bEnable = true;
        }
        this.text.setEnabled(bEnable);
        this.cbTyp.setEnabled(bEnable);
        this.cbSeverity.setEnabled(bEnable);
        this.ldInter.setSelection((Object)i);
    }
}

