/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.medikamente.bag.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.FlatDataLoader;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.medikamente.bag.data.BAGMedi;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TableViewer;

public class BagMediContentProvider
extends FlatDataLoader {
    PreparedStatement psSubst;
    PreparedStatement psNotes;
    PreparedStatement psMedi;
    private List<String> ids;
    private BAGMedi[] medis;
    private boolean bOnlyGenerics = false;
    private String sGroup = "";
    private boolean bOnlyStock;
    static final String FROM_SUBSTANCE = "SELECT j.product FROM CH_ELEXIS_MEDIKAMENTE_BAG_JOINT j, CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE s WHERE j.Substance=s.ID AND s.name LIKE ";

    public BagMediContentProvider(CommonViewer cv, Query<? extends PersistentObject> qbe) {
        super(cv, qbe);
        qbe.addPostQueryFilter((IFilter)new QueryFilter());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT m.product FROM ").append("CH_ELEXIS_MEDIKAMENTE_BAG_JOINT").append(" m, ").append("CH_ELEXIS_MEDIKAMENTE_BAG_SUBSTANCE").append(" s WHERE m.Substance=s.ID AND s.name LIKE ?;");
        this.psSubst = PersistentObject.getConnection().prepareStatement(sql.toString());
        sql.setLength(0);
        sql.append("SELECT id FROM ").append("CH_ELEXIS_MEDIKAMENTE_BAG_EXT").append(" WHERE Keywords LIKE ?;");
        this.psNotes = PersistentObject.getConnection().prepareStatement(sql.toString());
    }

    public IStatus work(IProgressMonitor monitor, HashMap<String, Object> params) {
        final TableViewer tv = (TableViewer)this.cv.getViewerWidget();
        this.qbe.clear();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.sGroup.length() > 0) {
            this.qbe.add("Gruppe", "=", this.sGroup);
            this.medis = this.qbe.execute().toArray(new BAGMedi[0]);
            this.cv.getConfigurer().getControlFieldProvider().clearValues();
            this.sGroup = "";
        } else {
            HashMap values = (HashMap)params.get("fieldvalues");
            if (values == null) {
                values = new HashMap();
            }
            if (values.isEmpty()) {
                this.qbe.orderBy(false, new String[]{"Name"});
                this.medis = this.qbe.execute().toArray(new BAGMedi[0]);
            } else {
                String subst = (String)values.get("Substanz");
                String notes = (String)values.get("Notizen");
                String names = (String)values.get("Name");
                if (StringTool.isNothing((Object)subst) && StringTool.isNothing((Object)notes)) {
                    this.qbe.add("Name", "Like", String.valueOf(names) + "%", true);
                    if (this.bOnlyGenerics) {
                        this.qbe.add("Generikum", "LIKE", "G%");
                    }
                    this.qbe.orderBy(false, new String[]{"Name"});
                    List<BAGMedi> result = this.qbe.execute();
                    if (this.bOnlyStock) {
                        result = result.stream().filter(a -> CoreHub.getStockService().getCumulatedAvailabilityForArticle((IArticle)((Artikel)a)) != null).collect(Collectors.toList());
                    }
                    this.medis = result.toArray(new BAGMedi[0]);
                } else {
                    if (!StringTool.isNothing((Object)subst)) {
                        String sql = FROM_SUBSTANCE + JdbcLink.wrap((String)(String.valueOf(subst) + "%"));
                        Collection mediRaw = this.qbe.queryExpression(sql, null);
                        this.medis = mediRaw == null ? new BAGMedi[0] : mediRaw.toArray(new BAGMedi[0]);
                    } else if (!StringTool.isNothing((Object)notes)) {
                        this.ids = this.qbe.execute(this.psNotes, new String[]{"%" + notes + "%"});
                        this.medis = new BAGMedi[this.ids.size()];
                    } else {
                        this.medis = new BAGMedi[0];
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
            }
        }
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                tv.setItemCount(0);
                tv.setItemCount(BagMediContentProvider.this.medis.length);
            }
        });
        return Status.OK_STATUS;
    }

    public void updateElement(int index) {
        if (index < this.medis.length) {
            if (this.medis[index] == null) {
                this.medis[index] = BAGMedi.load(this.ids.get(index));
            }
            TableViewer tv = (TableViewer)this.cv.getViewerWidget();
            tv.replace((Object)this.medis[index], index);
        }
    }

    public void setGroup(String group) {
        this.sGroup = group;
    }

    public boolean toggleGenericsOnly() {
        this.bOnlyGenerics = !this.bOnlyGenerics;
        return this.bOnlyGenerics;
    }

    public boolean toggleStockOnly() {
        this.bOnlyStock = !this.bOnlyStock;
        return this.bOnlyStock;
    }

    class QueryFilter
    implements IFilter {
        QueryFilter() {
        }

        public boolean select(Object element) {
            BAGMedi medi = (BAGMedi)element;
            return !BagMediContentProvider.this.bOnlyGenerics || medi.isGenericum();
        }
    }
}

