/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.medikamente.bag.views;

import ch.elexis.base.ch.medikamente.bag.views.BAGMediLabelProvider;
import ch.elexis.base.ch.medikamente.bag.views.BagMediContentProvider;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.artikel.ArtikelContextMenu;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.medikamente.bag.data.BAGMedi;
import ch.elexis.medikamente.bag.data.BAGMediFactory;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;

public class BAGMediSelector
extends CodeSelectorFactory {
    public static final String FIELD_NAME = "Name";
    public static final String FIELD_SUBSTANCE = "Substanz";
    public static final String FIELD_NOTES = "Notizen";
    private IAction sameOfGroupAction;
    private IAction genericsAction;
    private IAction onStockAction;
    CommonViewer cv;
    SelectorPanelProvider slp;
    FieldDescriptor<?>[] fields = new FieldDescriptor[]{new FieldDescriptor("Name", "Name", FieldDescriptor.Typ.STRING, null), new FieldDescriptor("Substanz", "Substanz", FieldDescriptor.Typ.STRING, null), new FieldDescriptor("Notizen", "Notizen", FieldDescriptor.Typ.STRING, null)};
    BagMediContentProvider fdl;

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        this.makeActions();
        ArtikelContextMenu menu = new ArtikelContextMenu((Artikel)((BAGMedi)new BAGMediFactory().createTemplate(BAGMedi.class)), cv);
        menu.addAction(this.sameOfGroupAction);
        this.slp = new SelectorPanelProvider(this.fields, true);
        this.slp.addActions(new IAction[]{this.genericsAction, this.onStockAction});
        this.fdl = new BagMediContentProvider(cv, (Query<? extends PersistentObject>)new Query(BAGMedi.class));
        this.cv = cv;
        return new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)this.fdl, (LabelProvider)new BAGMediLabelProvider(), (ViewerConfigurer.ControlFieldProvider)this.slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 0, null));
    }

    public void dispose() {
        this.cv.dispose();
        this.fdl.dispose();
    }

    public String getCodeSystemName() {
        return "Medikament";
    }

    public Class<? extends PersistentObject> getElementClass() {
        return BAGMedi.class;
    }

    private void makeActions() {
        this.sameOfGroupAction = new Action("Selbe therap. Gruppe"){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText("Zeige alle Medikamente derselben therapeutischen Gruppe");
            }

            public void run() {
                BAGMedi selected = (BAGMedi)BAGMediSelector.this.cv.getSelection()[0];
                BAGMediSelector.this.fdl.setGroup(selected.get("Gruppe"));
                BAGMediSelector.this.slp.fireChangedEvent();
            }
        };
        this.genericsAction = new Action("Nur Generika"){
            ImageDescriptor image_off;
            ImageDescriptor image_on;
            {
                String img_off = "icons" + File.separator + "ggruen.png";
                String img_on = "icons" + File.separator + "ggruen_on.png";
                this.image_off = BAGMediFactory.loadImageDescriptor(img_off);
                this.image_on = BAGMediFactory.loadImageDescriptor(img_on);
                this.setImageDescriptor(this.image_off);
                this.setToolTipText("Nur Generika anzeigen");
            }

            public void run() {
                if (BAGMediSelector.this.fdl.toggleGenericsOnly()) {
                    this.setImageDescriptor(this.image_on);
                } else {
                    this.setImageDescriptor(this.image_off);
                }
                BAGMediSelector.this.slp.fireChangedEvent();
            }
        };
        this.onStockAction = new Action("Nur Lagerartikel"){
            ImageDescriptor image_on;
            ImageDescriptor image_off;
            {
                this.image_on = null;
                this.image_off = null;
                String img_off = "icons" + File.separator + "lager.png";
                String img_on = "icons" + File.separator + "lager_on.png";
                this.image_off = BAGMediFactory.loadImageDescriptor(img_off);
                this.image_on = BAGMediFactory.loadImageDescriptor(img_on);
                this.setImageDescriptor(this.image_off);
                this.setToolTipText("Nur Lagerartikel anzeigen");
            }

            public void run() {
                if (BAGMediSelector.this.fdl.toggleStockOnly()) {
                    this.setImageDescriptor(this.image_on);
                } else {
                    this.setImageDescriptor(this.image_off);
                }
                BAGMediSelector.this.slp.fireChangedEvent();
            }
        };
    }
}

