/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.medikamente.bag.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Artikel;
import ch.elexis.medikamente.bag.data.BAGMedi;
import ch.elexis.medikamente.bag.data.Substance;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class BAGMediLabelProvider
extends DefaultLabelProvider
implements ITableColorProvider {
    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof BAGMedi) {
            IStockService.Availability availability;
            BAGMedi bm = (BAGMedi)element;
            StringBuilder sb = new StringBuilder();
            sb.append(bm.getLabel()).append(" <").append(bm.getVKPreis().getAmountAsString()).append(">");
            List<Substance> conts = bm.getSubstances();
            if (conts.size() > 0) {
                sb.append("[");
                for (Substance s : conts) {
                    sb.append(s.getLabel()).append("; ");
                }
                sb.append("]");
            }
            if ((availability = CoreHub.getStockService().getCumulatedAvailabilityForArticle((IArticle)bm)) != null) {
                sb.append(" (").append(availability).append(")");
            }
            return sb.toString();
        }
        return super.getColumnText(element, columnIndex);
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (element instanceof Artikel) {
            Artikel art = (Artikel)element;
            IStockService.Availability availability = CoreHub.getStockService().getCumulatedAvailabilityForArticle((IArticle)art);
            if (availability != null) {
                switch (availability) {
                    case CRITICAL_STOCK: 
                    case OUT_OF_STOCK: {
                        return UiDesk.getColor((String)"rot");
                    }
                }
                return UiDesk.getColor((String)"blau");
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof BAGMedi) {
            BAGMedi bm = (BAGMedi)element;
            String g = StringTool.unNull((String)bm.get("Generikum"));
            if (g.startsWith("G")) {
                return UiDesk.getImage((String)"ch.elexis.medikamente.bag.generikum");
            }
            if (g.startsWith("O")) {
                return UiDesk.getImage((String)"ch.elexis.medikamente.bag.has_generika");
            }
            return UiDesk.getImage((String)"ch.elexis.medikamente.bag.original");
        }
        return super.getColumnImage(element, columnIndex);
    }
}

