/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.medikamente.bag.views;

import ch.elexis.base.ch.medikamente.bag.views.InteraktionsDialog;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.settings.UserSettings;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.controls.StockDetailComposite;
import ch.elexis.data.Artikel;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.medikamente.bag.data.BAGMedi;
import ch.elexis.medikamente.bag.data.Interaction;
import ch.elexis.medikamente.bag.data.Substance;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BAGMediDetailBlatt
extends Composite {
    private static final String BAGMEDI_DETAIL_BLATT_INTERACTIONS = "BAGMediDetailBlatt/interactions";
    private static final String BAGMEDI_DETAIL_BLATT_SUBSTANCES = "BAGMediDetailBlatt/substances";
    private static final String FACHINFORMATIONEN = "Fachinformationen";
    private static final String KEYWORDS = "Notizen, Schl\u00fcsselbegriffe";
    private static final String BAGMEDI_DETAIL_BLATT_KEYWORDS = "BAGMediDetailBlatt/keywords";
    private static final String BAGMEDI_DETAIL_BLATT_PROFINFOS = "BAGMediDetailBlatt/profinfos";
    private final LabeledInputField.AutoForm fld;
    private final Text tSubstances;
    private final Text tInfos;
    private final Text tKeywords;
    private final Composite parent;
    private final ScrolledForm form;
    ListDisplay<Interaction> ldInteraktionen;
    private BAGMedi actMedi;
    private StockDetailComposite sdc;
    ExpandableComposite ecSubst;
    ExpandableComposite ecInterakt;
    ExpandableComposite ecFachinfo;
    ExpandableComposite ecKeywords;
    LabeledInputField.InputData[] fields = new LabeledInputField.InputData[]{new LabeledInputField.InputData("Hersteller", "ExtInfo", new LabeledInputField.IContentProvider(){

        public void displayContent(PersistentObject po, LabeledInputField.InputData ltf) {
            Kontakt hersteller = ((BAGMedi)po).getHersteller();
            if (hersteller.isValid()) {
                String lbl = hersteller.getLabel();
                if (lbl.length() > 15) {
                    lbl = String.valueOf(lbl.substring(0, 12)) + "...";
                }
                ltf.setText(lbl);
            } else {
                ltf.setText("?");
            }
        }

        public void reloadContent(PersistentObject po, LabeledInputField.InputData ltf) {
        }
    }), new LabeledInputField.InputData("Therap. Gruppe", "Gruppe", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData("Generika", "ExtInfo", LabeledInputField.InputData.Typ.STRING, "Generika"), new LabeledInputField.InputData("Pharmacode", "ExtInfo", LabeledInputField.InputData.Typ.STRING, "Pharmacode"), new LabeledInputField.InputData("BAG-Dossier", "ExtInfo", LabeledInputField.InputData.Typ.STRING, "BAG-Dossier"), new LabeledInputField.InputData("Swissmedic-Nr", "ExtInfo", LabeledInputField.InputData.Typ.STRING, "Swissmedic-Nr"), new LabeledInputField.InputData("Swissmedic-Liste", "ExtInfo", LabeledInputField.InputData.Typ.STRING, "Swissmedic-Liste"), new LabeledInputField.InputData("ExFactory", "EK_Preis", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData("Verkauf", "VK_Preis", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData("Limitatio", "ExtInfo", LabeledInputField.InputData.Typ.STRING, "Limitatio"), new LabeledInputField.InputData("LimitatioPts", "ExtInfo", LabeledInputField.InputData.Typ.STRING, "LimitatioPts"), new LabeledInputField.InputData("St\u00fcck pro Packung", "ExtInfo", LabeledInputField.InputData.Typ.INT, "VerpackungsEinheit"), new LabeledInputField.InputData("St\u00fcck pro Abgabe", "ExtInfo", LabeledInputField.InputData.Typ.INT, "Verkaufseinheit")};

    public BAGMediDetailBlatt(final Composite pr) {
        super(pr, 0);
        FormToolkit tk = UiDesk.getToolkit();
        this.parent = pr;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.form = tk.createScrolledForm((Composite)this);
        Composite ret = this.form.getBody();
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        this.fld = new LabeledInputField.AutoForm(ret, this.fields);
        this.fld.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        tk.adapt((Composite)this.fld);
        Group grpStockDetails = new Group(ret, 0);
        grpStockDetails.setLayout((Layout)new GridLayout(1, false));
        grpStockDetails.setText("Lagerhaltung");
        tk.adapt((Composite)grpStockDetails);
        this.sdc = new StockDetailComposite((Composite)grpStockDetails, 0);
        this.sdc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.ecSubst = tk.createExpandableComposite(ret, 2);
        this.ecSubst.setText("Inhaltsstoffe");
        this.tSubstances = SWTHelper.createText((FormToolkit)tk, (Composite)this.ecSubst, (int)5, (int)584);
        this.ecSubst.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UserSettings.saveExpandedState((String)BAGMediDetailBlatt.BAGMEDI_DETAIL_BLATT_SUBSTANCES, (boolean)e.getState());
                BAGMediDetailBlatt.this.form.reflow(true);
            }
        });
        this.ecSubst.setClient((Control)this.tSubstances);
        this.ecInterakt = tk.createExpandableComposite(ret, 2);
        this.ecInterakt.setText("Bisher eingetragene Interaktionen");
        this.ldInteraktionen = new ListDisplay((Composite)this.ecInterakt, 2048, new ListDisplay.LDListener(){

            public String getLabel(Object o) {
                if (o instanceof Interaction) {
                    Interaction inter = (Interaction)o;
                    return inter.getLabel();
                }
                return "?";
            }

            public void hyperlinkActivated(String l) {
                InteraktionsDialog idlg = new InteraktionsDialog(pr.getShell(), BAGMediDetailBlatt.this.actMedi);
                idlg.open();
            }
        });
        this.ldInteraktionen.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.ldInteraktionen.addHyperlinks(new String[]{"Bearbeiten..."});
        this.ecInterakt.setClient(this.ldInteraktionen);
        this.ecInterakt.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UserSettings.saveExpandedState((String)BAGMediDetailBlatt.BAGMEDI_DETAIL_BLATT_INTERACTIONS, (boolean)e.getState());
                BAGMediDetailBlatt.this.form.reflow(true);
            }
        });
        this.ecKeywords = tk.createExpandableComposite(ret, 2);
        this.tKeywords = SWTHelper.createText((Composite)this.ecKeywords, (int)3, (int)0);
        this.tKeywords.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BAGMediDetailBlatt.this.actMedi.set("keywords", BAGMediDetailBlatt.this.tKeywords.getText());
            }
        });
        this.ecKeywords.setClient((Control)this.tKeywords);
        this.ecKeywords.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UserSettings.saveExpandedState((String)BAGMediDetailBlatt.BAGMEDI_DETAIL_BLATT_KEYWORDS, (boolean)e.getState());
                BAGMediDetailBlatt.this.form.reflow(true);
            }
        });
        this.ecKeywords.setText(KEYWORDS);
        this.ecFachinfo = tk.createExpandableComposite(ret, 2);
        this.ecFachinfo.setText(FACHINFORMATIONEN);
        this.tInfos = SWTHelper.createText((Composite)this.ecFachinfo, (int)15, (int)0);
        this.ecFachinfo.setClient((Control)this.tInfos);
        this.ecFachinfo.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UserSettings.saveExpandedState((String)BAGMediDetailBlatt.BAGMEDI_DETAIL_BLATT_PROFINFOS, (boolean)e.getState());
                BAGMediDetailBlatt.this.form.reflow(true);
            }
        });
        this.tInfos.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BAGMediDetailBlatt.this.actMedi.set("KompendiumText", BAGMediDetailBlatt.this.tInfos.getText());
            }
        });
    }

    public void display(BAGMedi m) {
        this.actMedi = m;
        this.sdc.setArticle((Artikel)m);
        this.form.setText(m.getLabel());
        this.fld.reload((PersistentObject)m);
        List<Substance> list = m.getSubstances();
        StringBuilder sb = new StringBuilder();
        for (Substance s : list) {
            sb.append(s.getLabel()).append("\n");
        }
        this.tSubstances.setText(sb.toString());
        this.ldInteraktionen.clear();
        for (Interaction inter : m.getInteraktionen()) {
            this.ldInteraktionen.add((Object)inter);
        }
        this.tInfos.setText(StringTool.unNull((String)m.get("KompendiumText")));
        this.tKeywords.setText(StringTool.unNull((String)m.get("keywords")));
        UserSettings.setExpandedState((ExpandableComposite)this.ecSubst, (String)BAGMEDI_DETAIL_BLATT_SUBSTANCES);
        UserSettings.setExpandedState((ExpandableComposite)this.ecInterakt, (String)BAGMEDI_DETAIL_BLATT_INTERACTIONS);
        UserSettings.setExpandedState((ExpandableComposite)this.ecFachinfo, (String)BAGMEDI_DETAIL_BLATT_PROFINFOS);
        UserSettings.setExpandedState((ExpandableComposite)this.ecKeywords, (String)BAGMEDI_DETAIL_BLATT_KEYWORDS);
        this.form.reflow(true);
    }
}

