/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labortarif2009.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class Optifier
implements IOptifier {
    private Verrechnet newVerrechnet;

    public Result<IVerrechenbar> add(IVerrechenbar code, Konsultation kons) {
        boolean bOptify = CoreHub.userCfg.get("billing/optify", true);
        if (code instanceof Labor2009Tarif) {
            TimeTool date;
            Labor2009Tarif tarif;
            if (bOptify && !(tarif = (Labor2009Tarif)code).isValidOn(date = new TimeTool(kons.getDatum()))) {
                TimeTool validFrom = new TimeTool(tarif.get("GueltigVon"));
                TimeTool validTo = new TimeTool(tarif.get("GueltigBis"));
                return new Result(Result.SEVERITY.ERROR, 2, String.valueOf(code.getCode()) + " (" + validFrom.toString(4) + "-" + validTo.toString(4) + ") G\u00fcltigkeit beinhaltet nicht das Konsultationsdatum " + kons.getDatum(), null, false);
            }
            this.newVerrechnet = new Verrechnet(code, kons, 1);
            Result<Object> res = this.optify(kons);
            if (res.isOK()) {
                return new Result((Object)code);
            }
            this.newVerrechnet.delete();
            return new Result(res.getSeverity(), res.getCode(), res.toString(), (Object)code, true);
        }
        return new Result(Result.SEVERITY.ERROR, 2, "No Lab2009Tariff", null, true);
    }

    public Result<Object> optify(Konsultation kons) {
        if (!CoreHub.localCfg.get("abrechnung/labor2009/optify", true)) {
            return new Result((Object)kons);
        }
        try {
            boolean haveKons = false;
            TimeTool date = new TimeTool(kons.getDatum());
            TimeTool deadline = CoreHub.globalCfg.getDate("abrechnung/labor2009/optify/addition/deadline");
            if (deadline == null) {
                deadline = new TimeTool("30.06.2013");
            }
            if (date.isBefore(new TimeTool("01.07.2009"))) {
                return new Result(Result.SEVERITY.WARNING, 3, "Code not yet valid", null, false);
            }
            List list = kons.getLeistungen();
            Verrechnet v470710 = null;
            Verrechnet v470720 = null;
            Verrechnet v4708 = null;
            int z4708 = 0;
            boolean z4707 = false;
            int z470710 = 0;
            int z470720 = 0;
            for (Verrechnet v : list) {
                IVerrechenbar iv = v.getVerrechenbar();
                if (iv instanceof Labor2009Tarif) {
                    String cc = v.getVerrechenbar().getCode();
                    if (cc.equals("4708.00")) {
                        v4708 = v;
                        continue;
                    }
                    if (cc.equals("4707.00")) {
                        if (z4707 < true) {
                            z4707 = true;
                            continue;
                        }
                        return new Result(Result.SEVERITY.WARNING, 1, "4707.00 only once per cons", (Object)v, false);
                    }
                    if (cc.equals("4707.10")) {
                        v470710 = v;
                        continue;
                    }
                    if (cc.equals("4707.20")) {
                        v470720 = v;
                        continue;
                    }
                    if (cc.equals("4703.00") || cc.equals("4701.00") || cc.equals("4704.00") || cc.equals("4706.00")) continue;
                    Labor2009Tarif vlt = (Labor2009Tarif)iv;
                    if (!this.isSchnellAnalyse(vlt)) {
                        if (vlt.get("fachbereich").indexOf("C") > -1) {
                            z470710 += v.getZahl();
                        } else {
                            z470720 += v.getZahl();
                        }
                    }
                    z4708 += v.getZahl();
                    continue;
                }
                if (!iv.getCode().equals("00.0010") && !iv.getCode().equals("00.0060")) continue;
                haveKons = true;
            }
            while (4 + 2 * z470710 + z470720 > 26 && z470710 > 0) {
                --z470710;
            }
            while (4 + 2 * z470710 + z470720 > 24 && z470720 > 0) {
                --z470720;
            }
            if (z470710 == 0 || !haveKons) {
                if (v470710 != null) {
                    v470710.delete();
                }
            } else {
                if (v470710 == null) {
                    v470710 = this.doCreate(kons, "4707.10");
                }
                v470710.setZahl(z470710);
            }
            if (z470720 == 0 || !haveKons) {
                if (v470720 != null) {
                    v470720.delete();
                }
            } else {
                if (v470720 == null) {
                    v470720 = this.doCreate(kons, "4707.20");
                }
                v470720.setZahl(z470720);
            }
            if (date.isBefore(new TimeTool("01.01.2015"))) {
                if (!z4707 && z470710 + z470720 > 0 && haveKons) {
                    this.doCreate(kons, "4707.00");
                }
                if (z4708 > 0 && haveKons) {
                    if (v4708 == null) {
                        if (date.isBefore(deadline)) {
                            v4708 = this.doCreate(kons, "4708.00");
                        }
                    } else if (date.isAfterOrEqual(deadline)) {
                        v4708.delete();
                        return new Result(Result.SEVERITY.WARNING, 2, "4708.00 only until " + deadline.toString(4), null, false);
                    }
                }
                if (v4708 != null) {
                    v4708.setZahl(z4708);
                }
            }
            return new Result((Object)kons);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return new Result(Result.SEVERITY.ERROR, 1, "Tariff not installed correctly", null, true);
        }
    }

    private boolean isSchnellAnalyse(Labor2009Tarif vlt) {
        String chapter = vlt.get("chapter").trim();
        if (chapter != null && !chapter.isEmpty()) {
            String[] chapters;
            String[] stringArray = chapters = chapter.split(",");
            int n = chapters.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.trim().equals("5.1.2.2.1")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Result<Verrechnet> remove(Verrechnet code, Konsultation kons) {
        List l = kons.getLeistungen();
        l.remove(code);
        code.delete();
        Result<Object> res = this.optify(kons);
        if (res.isOK()) {
            return new Result((Object)code);
        }
        return new Result(res.getSeverity(), res.getCode(), res.toString(), (Object)code, true);
    }

    private Verrechnet doCreate(Konsultation kons, String code) throws Exception {
        Query query = new Query(Labor2009Tarif.class);
        query.add("code", "=", code);
        List list = query.execute();
        Labor2009Tarif tarif = null;
        for (Labor2009Tarif labor2009Tarif : list) {
            if (!labor2009Tarif.isValidOn(new TimeTool(kons.getDatum()))) continue;
            tarif = labor2009Tarif;
            break;
        }
        if (tarif != null) {
            this.newVerrechnet = new Verrechnet(tarif, kons, 1);
            return this.newVerrechnet;
        }
        throw new Exception("Tariff not installed correctly");
    }

    public Verrechnet getCreatedVerrechnet() {
        return this.newVerrechnet;
    }
}

