/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labortarif2009.data;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.data.UiVerrechenbarAdapter;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import ch.elexis.labortarif2009.data.Optifier;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class Labor2009Tarif
extends UiVerrechenbarAdapter {
    public static final String FLD_GUELTIG_BIS = "GueltigBis";
    public static final String FLD_GUELTIG_VON = "GueltigVon";
    public static final String CODESYSTEM_CODE_LAB2009 = "317";
    public static final String CODESYSTEM_CODE_TARMED = "300";
    public static final String MULTIPLICATOR_NAME = "EAL2009";
    public static final String CODESYSTEM_NAME = "EAL 2009";
    public static final String FLD_FACHBEREICH = "fachbereich";
    public static final String FLD_LIMITATIO = "limitatio";
    public static final String FLD_NAME = "name";
    public static final String FLD_TP = "tp";
    public static final String FLD_CODE = "code";
    public static final String FLD_CHAPTER = "chapter";
    public static final String FLD_FACHSPEC = "praxistyp";
    public static final String XIDDOMAIN = "www.xid.ch/id/analysenliste_ch2009/";
    private static final String TABLENAME = "CH_MEDELEXIS_LABORTARIF2009";
    public static final String VERSION010 = "0.1.0";
    public static final String VERSION011 = "0.1.1";
    public static final String VERSION = "0.1.2";
    private static final String createTable = "create table CH_MEDELEXIS_LABORTARIF2009(ID\t\tVARCHAR(25) primary key,lastupdate BIGINT,deleted\t CHAR(1) default '0',chapter   VARCHAR(255),code\t\t VARCHAR(12),tp\t\t VARCHAR(10),name\t\t VARCHAR(255),limitatio TEXT,fachbereich VARCHAR(10),GueltigVon CHAR(8),GueltigBis CHAR(8),praxistyp VARCHAR(2));INSERT INTO CH_MEDELEXIS_LABORTARIF2009(ID,code) VALUES (1,'0.1.2');";
    private static final IOptifier l09optifier = new Optifier();
    private static TimeTool future = new TimeTool("01.01.9999");

    static {
        Labor2009Tarif.createTable();
    }

    static void createTable() {
        Labor2009Tarif.addMapping((String)TABLENAME, (String[])new String[]{FLD_CHAPTER, FLD_CODE, FLD_TP, FLD_NAME, FLD_LIMITATIO, FLD_FACHBEREICH, FLD_FACHSPEC, FLD_GUELTIG_BIS, FLD_GUELTIG_VON});
        Labor2009Tarif version = Labor2009Tarif.load("1");
        if (!version.exists()) {
            Labor2009Tarif.createOrModifyTable((String)createTable);
        }
        if (version.get(FLD_CODE).equals(VERSION010)) {
            Labor2009Tarif.createOrModifyTable((String)"ALTER TABLE CH_MEDELEXIS_LABORTARIF2009 ADD GueltigVon CHAR(8); ALTER TABLE CH_MEDELEXIS_LABORTARIF2009 ADD GueltigBis CHAR(8);");
            Labor2009Tarif.createOrModifyTable((String)"ALTER TABLE CH_MEDELEXIS_LABORTARIF2009 MODIFY chapter VARCHAR(255);");
            version.set(FLD_CODE, VERSION);
        }
        if (version.get(FLD_CODE).equals(VERSION011)) {
            Labor2009Tarif.createOrModifyTable((String)"ALTER TABLE CH_MEDELEXIS_LABORTARIF2009 MODIFY chapter VARCHAR(255);");
            version.set(FLD_CODE, VERSION);
        }
        Xid.localRegisterXIDDomainIfNotExists((String)XIDDOMAIN, (String)"Analysenliste 2009", (int)2);
    }

    Labor2009Tarif(String chapter, String code, String tp, String name, String lim, String fach, int fachspec) {
        this.create(null);
        this.set(new String[]{FLD_CHAPTER, FLD_CODE, FLD_TP, FLD_NAME, FLD_LIMITATIO, FLD_FACHBEREICH, FLD_FACHSPEC}, new String[]{chapter, code, tp, name, lim, fach, Integer.toString(fachspec)});
    }

    public String getLabel() {
        String[] values = this.get(true, new String[]{FLD_GUELTIG_VON, FLD_GUELTIG_BIS, FLD_CODE, FLD_NAME});
        String validFromString = values[0];
        String validToString = values[1];
        String code = values[2];
        String text = StringTool.getFirstLine((String)values[3], (int)80);
        if (!StringTool.isNothing((Object)code)) {
            StringBuilder sb = new StringBuilder(code).append(" ").append(text).append(" (").append(this.get(FLD_FACHBEREICH)).append(")");
            TimeTool validFrom = null;
            TimeTool validTo = null;
            if (validFromString != null && validFromString.trim().length() > 0) {
                validFrom = new TimeTool(validFromString);
            }
            if (validToString != null && validToString.trim().length() > 0) {
                validTo = new TimeTool(validToString);
            }
            if (validFrom != null) {
                sb.append(" (").append(validFrom.toString(4));
                if (validTo != null) {
                    sb.append("-").append(validTo.toString(4)).append(")");
                } else {
                    sb.append("-").append(" ").append(")");
                }
            }
            return sb.toString();
        }
        return "?";
    }

    public String getCode() {
        return this.get(FLD_CODE);
    }

    public String getText() {
        return StringTool.getFirstLine((String)this.get(FLD_NAME), (int)80);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Labor2009Tarif load(String id) {
        return new Labor2009Tarif(id);
    }

    protected Labor2009Tarif(String id) {
        super(id);
    }

    public Labor2009Tarif() {
    }

    public String getXidDomain() {
        return XIDDOMAIN;
    }

    public double getFactor(TimeTool date, IFall fall) {
        double ret = this.getVKMultiplikator(date, MULTIPLICATOR_NAME);
        return ret;
    }

    public int getTP(TimeTool date, IFall fall) {
        double tp = Labor2009Tarif.checkZeroDouble((String)this.get(FLD_TP));
        return (int)Math.round(tp * 100.0);
    }

    public boolean isValidOn(TimeTool date) {
        TimeTool validTo;
        TimeTool validFrom;
        String validFromString = this.get(FLD_GUELTIG_VON);
        String validToString = this.get(FLD_GUELTIG_BIS);
        if (validFromString != null && validFromString.trim().length() > 0 && (validFrom = new TimeTool(validFromString)).after((Object)date)) {
            return false;
        }
        return validToString == null || validToString.trim().length() <= 0 || !(validTo = new TimeTool(validToString)).before((Object)date) && !validTo.equals((Object)date);
    }

    public static int getCurrentCodeVersion() {
        Labor2009Tarif version = Labor2009Tarif.load("1");
        String currentVersion = version.get(FLD_CHAPTER);
        if (currentVersion != null && !currentVersion.isEmpty()) {
            return Integer.parseInt(currentVersion);
        }
        return 0;
    }

    public static void setCurrentCodeVersion(int value) {
        Labor2009Tarif version = Labor2009Tarif.load("1");
        version.set(FLD_CHAPTER, Integer.toString(value));
    }

    public boolean isDragOK() {
        return true;
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public String getCodeSystemCode() {
        return CODESYSTEM_CODE_LAB2009;
    }

    public IOptifier getOptifier() {
        return l09optifier;
    }

    public IVerrechenbar.VatInfo getVatInfo() {
        return IVerrechenbar.VatInfo.VAT_NONE;
    }

    public static Labor2009Tarif getFromCode(String code, TimeTool date) {
        Query query = new Query(Labor2009Tarif.class);
        query.add(FLD_CODE, "=", code);
        List leistungen = query.execute();
        for (Labor2009Tarif laborLeistung : leistungen) {
            TimeTool validFrom = laborLeistung.getGueltigVon();
            TimeTool validTo = laborLeistung.getGueltigBis();
            if (validTo == null) {
                validTo = future;
            }
            if (!date.isAfterOrEqual(validFrom) || !date.isBeforeOrEqual(validTo)) continue;
            return laborLeistung;
        }
        return null;
    }

    private TimeTool getGueltigBis() {
        String value = this.get(FLD_GUELTIG_BIS);
        if (!StringTool.isNothing((Object)value)) {
            TimeTool res = new TimeTool(value);
            res.set(11, 23);
            res.set(12, 59);
            res.set(13, 59);
            return res;
        }
        return null;
    }

    private TimeTool getGueltigVon() {
        String value = this.get(FLD_GUELTIG_VON);
        if (!StringTool.isNothing((Object)value)) {
            return new TimeTool(value);
        }
        return null;
    }
}

