/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labortarif2009.data;

import ch.elexis.base.ch.labortarif_2009.Messages;
import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.labortarif2009.data.EALReferenceDataImporter;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class Importer
extends ImporterPage {
    TimeTool validFrom = new TimeTool();
    Fachspec[] specs;
    int row;

    public Importer() {
        this.validFrom.clear();
        this.validFrom.set(TimeTool.getInstance().get(1), 0, 1);
    }

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter fis = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        fis.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite validDateComposite = new Composite((Composite)fis, 0);
        validDateComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        validDateComposite.setLayout((Layout)new FormLayout());
        Label lbl = new Label(validDateComposite, 0);
        lbl.setText("Tarif ist g\u00fcltig ab:");
        final DateTime validDate = new DateTime(validDateComposite, 65572);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(20, -5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(20, 5);
        validDate.setLayoutData((Object)fd);
        validDate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.setValidFromDate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.setValidFromDate();
            }

            private void setValidFromDate() {
                Importer.this.validFrom.set(validDate.getYear(), validDate.getMonth(), validDate.getDay());
            }
        });
        validDate.setDate(this.validFrom.get(1), this.validFrom.get(2), this.validFrom.get(5));
        return fis;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        EALReferenceDataImporter refImporter = new EALReferenceDataImporter();
        try (FileInputStream tarifInputStream = new FileInputStream(this.results[0]);){
            IStatus iStatus = refImporter.performImport(monitor, tarifInputStream, refImporter.getVersionFromValid(this.validFrom));
            return iStatus;
        }
    }

    public String getDescription() {
        return Messages.Importer_selectFile;
    }

    public String getTitle() {
        return "EAL 2009";
    }

    public static Fachspec[] loadFachspecs(int langdef) {
        String specs = String.valueOf(PlatformHelper.getBasePath((String)"ch.elexis.base.ch.labortarif_2009")) + File.separator + "rsc" + File.separator + "arztpraxen.xls";
        ExcelWrapper x = new ExcelWrapper();
        x.setFieldTypes(new Class[]{Integer.class, String.class, Integer.class, Integer.class});
        if (x.load(specs, langdef)) {
            int first = x.getFirstRow();
            int last = x.getLastRow();
            Fachspec[] fspecs = new Fachspec[last - first + 1];
            int i = first;
            while (i <= last) {
                fspecs[i] = new Fachspec(x.getRow(i).toArray(new String[0]));
                ++i;
            }
            return fspecs;
        }
        return null;
    }

    public static class Fachspec {
        public int code;
        public int from;
        public int until;
        public String name;

        Fachspec(String[] line) {
            this(Integer.parseInt(StringTool.getSafe((String[])line, (int)0)), StringTool.getSafe((String[])line, (int)1), Integer.parseInt(StringTool.getSafe((String[])line, (int)2)), Integer.parseInt(StringTool.getSafe((String[])line, (int)3)));
        }

        Fachspec(int code, String name, int from, int until) {
            this.code = code;
            this.from = from;
            this.until = until;
            this.name = name;
        }

        public static int getFachspec(Fachspec[] specs, int row) {
            Fachspec[] fachspecArray = specs;
            int n = specs.length;
            int n2 = 0;
            while (n2 < n) {
                Fachspec spec = fachspecArray[n2];
                if (spec.from <= row && spec.until >= row) {
                    return spec.code;
                }
                ++n2;
            }
            return -1;
        }
    }
}

