/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labortarif2009.data;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.elexis.labortarif2009.data.EALBlocksCodeUpdater;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class EALVerrechnet2015Updater {
    private TimeTool startDate = new TimeTool("1.1.2015");
    private static final String analysenChapter = "5.1.2.2.1";

    public void fix2015Chapters() {
        Labor2009Tarif tarif = Labor2009Tarif.getFromCode("1260.01", this.startDate);
        if (!this.isSchnellAnalyse(tarif)) {
            tarif.set("chapter", this.concatChapter(tarif, analysenChapter));
        }
        if (!this.isSchnellAnalyse(tarif = Labor2009Tarif.getFromCode("1356.01", this.startDate))) {
            tarif.set("chapter", this.concatChapter(tarif, analysenChapter));
        }
        if (!this.isSchnellAnalyse(tarif = Labor2009Tarif.getFromCode("1700.01", this.startDate))) {
            tarif.set("chapter", this.concatChapter(tarif, analysenChapter));
        }
        if (!this.isSchnellAnalyse(tarif = Labor2009Tarif.getFromCode("1740.01", this.startDate))) {
            tarif.set("chapter", this.concatChapter(tarif, analysenChapter));
        }
        if (!this.isSchnellAnalyse(tarif = Labor2009Tarif.getFromCode("3469.01", this.startDate))) {
            tarif.set("chapter", this.concatChapter(tarif, analysenChapter));
        }
    }

    private String concatChapter(Labor2009Tarif existing, String chapter) {
        String existingChapter = existing.get("chapter");
        if (existingChapter != null && !existingChapter.isEmpty()) {
            return String.valueOf(existingChapter) + ", " + chapter;
        }
        return chapter;
    }

    private boolean isSchnellAnalyse(Labor2009Tarif tarif) {
        String chapter = tarif.get("chapter").trim();
        if (chapter != null && !chapter.isEmpty()) {
            String[] chapters;
            String[] stringArray = chapters = chapter.split(",");
            int n = chapters.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.trim().equals(analysenChapter)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String update2015Verrechnet() {
        int absoluteCnt = 0;
        Query qk = new Query(Konsultation.class);
        qk.add("Datum", ">=", this.startDate.toString(9));
        EALBlocksCodeUpdater.AnalysenOnlyTarifResolver resolver = new EALBlocksCodeUpdater.AnalysenOnlyTarifResolver();
        List konsultationen = qk.execute();
        for (Konsultation konsultation : konsultationen) {
            List leistungen = konsultation.getLeistungen();
            if (leistungen == null || leistungen.isEmpty()) continue;
            for (Verrechnet verrechnet : leistungen) {
                IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                if (!(verrechenbar instanceof Labor2009Tarif)) continue;
                String code = verrechenbar.getCode();
                Labor2009Tarif analyseTarif = (Labor2009Tarif)resolver.getTarif(verrechenbar.getCode(), this.startDate);
                if (analyseTarif != null) {
                    konsultation.removeLeistung(verrechnet);
                    konsultation.addLeistung((IVerrechenbar)analyseTarif);
                    ++absoluteCnt;
                }
                if (!code.endsWith(".01")) continue;
                this.removeZuschlag(konsultation);
            }
        }
        return String.valueOf(absoluteCnt) + " EAL codes in Konsultationen angepasst.\n";
    }

    private void removeZuschlag(Konsultation konsultation) {
        List leistungen = konsultation.getLeistungen();
        if (leistungen != null && !leistungen.isEmpty()) {
            for (Verrechnet verrechnet : leistungen) {
                Labor2009Tarif tarif;
                String code;
                IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                if (!(verrechenbar instanceof Labor2009Tarif) || !(code = (tarif = (Labor2009Tarif)verrechenbar).getCode()).equals("4707.10") && !code.equals("4707.20")) continue;
                konsultation.removeLeistung(verrechnet);
            }
        }
    }
}

