/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labortarif2009.data;

import ch.elexis.base.ch.labortarif_2009.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.Query;
import ch.elexis.labortarif2009.data.EALBlocksCodeUpdater;
import ch.elexis.labortarif2009.data.Importer;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EALReferenceDataImporter
extends AbstractReferenceDataImporter {
    private static final Logger logger = LoggerFactory.getLogger(EALReferenceDataImporter.class);
    int langdef = 0;
    TimeTool validFrom;
    Importer.Fachspec[] specs;
    int row;
    private HashMap<String, String> importedValues = new HashMap();

    @NonNull
    public Class<?> getReferenceDataTypeResponsibleFor() {
        return Labor2009Tarif.class;
    }

    public IStatus performImport(@Nullable IProgressMonitor monitor, @NonNull InputStream input, @Nullable Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.validFrom = this.getValidFromVersion(newVersion);
        String lang = JdbcLink.wrap((String)CoreHub.localCfg.get("ablauf/sprache", "d").toUpperCase());
        if (lang.startsWith("F")) {
            this.langdef = 1;
        } else if (lang.startsWith("I")) {
            this.langdef = 2;
        }
        this.specs = Importer.loadFachspecs(this.langdef);
        if (this.specs != null) {
            ExcelWrapper exw = new ExcelWrapper();
            Class[] fields = new Class[30];
            int i = 0;
            while (i < fields.length) {
                fields[i] = String.class;
                ++i;
            }
            exw.setFieldTypes(fields);
            if (exw.load(input, this.langdef)) {
                int first = exw.getFirstRow();
                int last = exw.getLastRow();
                int count = last - first;
                if (monitor != null) {
                    monitor.beginTask(Messages.Importer_importEAL, count);
                }
                String[] line = exw.getRow(1).toArray(new String[0]);
                int formatYear = this.getFormatYear(line);
                int i2 = first + 1;
                while (i2 <= last) {
                    this.row = i2;
                    line = exw.getRow(i2).toArray(new String[0]);
                    switch (formatYear) {
                        case 2011: {
                            this.fillImportedValues2011(line);
                            break;
                        }
                        case 2012: {
                            this.fillImportedValues2012(line);
                            break;
                        }
                        case 2018: {
                            this.fillImportedValues2018(line);
                            break;
                        }
                        case 2023: {
                            this.fillImportedValues2023(line);
                            break;
                        }
                        default: {
                            return new Status(4, "ch.elexis.labotarif.ch2009", "unknown file format");
                        }
                    }
                    if (this.importedValues.size() > 0) {
                        this.updateOrCreateFromImportedValues();
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    ++i2;
                }
                this.closeAllOlder();
                if (monitor != null) {
                    monitor.done();
                }
                ElexisEventDispatcher.reload(Labor2009Tarif.class);
                if (newVersion != null) {
                    Labor2009Tarif.setCurrentCodeVersion(newVersion);
                }
                EALBlocksCodeUpdater blocksUpdater = new EALBlocksCodeUpdater();
                String message = blocksUpdater.updateBlockCodes();
                logger.info("Updated Blocks: \n" + message);
                return Status.OK_STATUS;
            }
        }
        return new Status(4, "ch.elexis.labotarif.ch2009", "could not load file");
    }

    private TimeTool getValidFromVersion(Integer newVersion) {
        String intString = Integer.toString(newVersion);
        if (intString.length() != 6) {
            throw new IllegalStateException("Version " + newVersion + " can not be parsed to valid date.");
        }
        String year = intString.substring(0, 2);
        String month = intString.substring(2, 4);
        String day = intString.substring(4, 6);
        TimeTool ret = new TimeTool();
        ret.set(1, Integer.parseInt(year) + 2000);
        ret.set(2, Integer.parseInt(month) - 1);
        ret.set(5, Integer.parseInt(day));
        return ret;
    }

    public int getVersionFromValid(TimeTool validFrom) {
        int year = validFrom.get(1);
        int month = validFrom.get(2) + 1;
        int day = validFrom.get(5);
        return day + month * 100 + (year - 2000) * 10000;
    }

    private void updateOrCreateFromImportedValues() {
        Query qEntries = new Query(Labor2009Tarif.class);
        qEntries.add("code", "=", this.importedValues.get("code"));
        List entries = qEntries.execute();
        ArrayList<Labor2009Tarif> openEntries = new ArrayList<Labor2009Tarif>();
        for (Labor2009Tarif labor2009Tarif : entries) {
            String gBis = labor2009Tarif.get("GueltigBis");
            if (gBis != null && gBis.trim().length() != 0) continue;
            openEntries.add(labor2009Tarif);
        }
        if (openEntries.isEmpty()) {
            Labor2009Tarif tarif = new Labor2009Tarif(this.importedValues.get("chapter"), this.importedValues.get("code"), this.importedValues.get("tp"), this.importedValues.get("name"), this.importedValues.get("limitatio"), this.importedValues.get("fachbereich"), Importer.Fachspec.getFachspec(this.specs, this.row));
            tarif.set("GueltigVon", this.validFrom.toString(9));
        } else {
            for (Labor2009Tarif labor2009Tarif : openEntries) {
                if (labor2009Tarif.get("GueltigVon").equals(this.validFrom.toString(9))) {
                    labor2009Tarif.set(new String[]{"chapter", "code", "tp", "name", "limitatio", "fachbereich", "praxistyp"}, new String[]{this.concatChapter(labor2009Tarif, this.importedValues.get("chapter")), this.importedValues.get("code"), this.importedValues.get("tp"), this.importedValues.get("name"), this.importedValues.get("limitatio"), this.importedValues.get("fachbereich"), Integer.toString(Importer.Fachspec.getFachspec(this.specs, this.row))});
                    continue;
                }
                labor2009Tarif.set("GueltigBis", this.validFrom.toString(9));
                Labor2009Tarif tarif = new Labor2009Tarif(this.importedValues.get("chapter"), this.importedValues.get("code"), this.importedValues.get("tp"), this.importedValues.get("name"), this.importedValues.get("limitatio"), this.importedValues.get("fachbereich"), Importer.Fachspec.getFachspec(this.specs, this.row));
                tarif.set("GueltigVon", this.validFrom.toString(9));
            }
        }
    }

    private String concatChapter(Labor2009Tarif existing, String chapter) {
        String existingChapter = existing.get("chapter");
        if (existingChapter != null && !existingChapter.isEmpty()) {
            return this.chaptersMakeUnique(String.valueOf(existingChapter) + ", " + chapter);
        }
        return this.chaptersMakeUnique(chapter);
    }

    private String chaptersMakeUnique(String chapters) {
        String[] parts = chapters.split(", ");
        if (parts != null && parts.length > 1) {
            StringBuilder sb = new StringBuilder();
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(parts));
            Object[] array = set.toArray(new String[set.size()]);
            Arrays.sort(array);
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object string = objectArray[n2];
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((String)string);
                ++n2;
            }
            return sb.toString();
        }
        return chapters;
    }

    private void fillImportedValues2023(String[] line) {
        this.importedValues.clear();
        this.importedValues.clear();
        this.importedValues.put("chapter", StringTool.getSafe((String[])line, (int)0));
        String code = this.convertCodeString(StringTool.getSafe((String[])line, (int)1));
        this.importedValues.put("code", code);
        this.importedValues.put("tp", this.convertLocalizedNumericString(StringTool.getSafe((String[])line, (int)2)).toString());
        this.importedValues.put("name", StringTool.limitLength((String)StringTool.getSafe((String[])line, (int)3), (int)254));
        this.importedValues.put("limitatio", StringTool.getSafe((String[])line, (int)8));
        String isChem = StringTool.getSafe((String[])line, (int)11);
        String isHaem = StringTool.getSafe((String[])line, (int)12);
        String isImm = StringTool.getSafe((String[])line, (int)13);
        String isGen = StringTool.getSafe((String[])line, (int)14);
        String isMikro = StringTool.getSafe((String[])line, (int)15);
        StringBuilder sb = new StringBuilder();
        if (isChem.equals("Ja")) {
            sb.append("C");
        }
        if (isHaem.equals("Ja")) {
            sb.append("H");
        }
        if (isImm.equals("Ja")) {
            sb.append("I");
        }
        if (isGen.equals("Ja")) {
            sb.append("G");
        }
        if (isMikro.equals("Ja")) {
            sb.append("M");
        }
        this.importedValues.put("fachbereich", sb.toString());
    }

    private void fillImportedValues2012(String[] line) {
        this.importedValues.clear();
        this.importedValues.put("chapter", StringTool.getSafe((String[])line, (int)0));
        String code = this.convertCodeString(StringTool.getSafe((String[])line, (int)2));
        this.importedValues.put("code", code);
        this.importedValues.put("tp", this.convertLocalizedNumericString(StringTool.getSafe((String[])line, (int)3)).toString());
        this.importedValues.put("name", StringTool.limitLength((String)StringTool.getSafe((String[])line, (int)4), (int)254));
        this.importedValues.put("limitatio", StringTool.getSafe((String[])line, (int)5));
        this.importedValues.put("fachbereich", StringTool.getSafe((String[])line, (int)7));
    }

    private void fillImportedValues2011(String[] line) {
        this.importedValues.clear();
        this.importedValues.put("chapter", StringTool.getSafe((String[])line, (int)0));
        String code = this.convertCodeString(StringTool.getSafe((String[])line, (int)2));
        this.importedValues.put("code", code);
        this.importedValues.put("tp", this.convertLocalizedNumericString(StringTool.getSafe((String[])line, (int)3)).toString());
        this.importedValues.put("name", StringTool.limitLength((String)StringTool.getSafe((String[])line, (int)4), (int)254));
        this.importedValues.put("limitatio", StringTool.getSafe((String[])line, (int)5));
        this.importedValues.put("fachbereich", StringTool.getSafe((String[])line, (int)6));
    }

    private void fillImportedValues2018(String[] line) {
        this.importedValues.clear();
        this.importedValues.put("chapter", StringTool.getSafe((String[])line, (int)0));
        String code = this.convertCodeString(StringTool.getSafe((String[])line, (int)1));
        this.importedValues.put("code", code);
        this.importedValues.put("tp", this.convertLocalizedNumericString(StringTool.getSafe((String[])line, (int)2)).toString());
        this.importedValues.put("name", StringTool.limitLength((String)StringTool.getSafe((String[])line, (int)3), (int)254));
        this.importedValues.put("limitatio", StringTool.getSafe((String[])line, (int)4));
        this.importedValues.put("fachbereich", StringTool.getSafe((String[])line, (int)5));
    }

    private void closeAllOlder() {
        TimeTool defaultValidFrom = new TimeTool();
        defaultValidFrom.set(1970, 0, 1);
        Query qEntries = new Query(Labor2009Tarif.class);
        List entries = qEntries.execute();
        for (Labor2009Tarif labor2009Tarif : entries) {
            String validFromString = labor2009Tarif.get("GueltigVon");
            String validUntilString = labor2009Tarif.get("GueltigBis");
            if (validFromString == null || validFromString.trim().length() == 0) {
                labor2009Tarif.set("GueltigVon", defaultValidFrom.toString(9));
                labor2009Tarif.set("GueltigBis", this.validFrom.toString(9));
                continue;
            }
            if (validUntilString != null && validUntilString.trim().length() != 0 || this.validFrom.toString(9).equals(validFromString)) continue;
            labor2009Tarif.set("GueltigBis", this.validFrom.toString(9));
        }
    }

    private String convertCodeString(String code) {
        String[] parts = code.split("[\\.,']");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            sb.append(part);
            if (sb.length() == 4) {
                sb.append(".");
            }
            ++n2;
        }
        if (sb.length() == 5) {
            sb.append("00");
        } else if (sb.length() == 6) {
            sb.append("0");
        }
        return sb.toString();
    }

    private String convertLocalizedNumericString(String localized) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        Number number = new Integer(0);
        try {
            number = df.parse(localized);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (number.doubleValue() % 1.0 > 0.0) {
            return Double.toString(number.doubleValue());
        }
        return Integer.toString(number.intValue());
    }

    private int getFormatYear(String[] line) {
        String fach2011 = StringTool.getSafe((String[])line, (int)6);
        String fach2012 = StringTool.getSafe((String[])line, (int)7);
        String code2018 = StringTool.getSafe((String[])line, (int)1);
        if (fach2012.equals("") && !fach2011.equals("")) {
            if (this.isCode(code2018)) {
                return 2018;
            }
            return 2011;
        }
        if (fach2011.equals("") && !fach2012.equals("")) {
            return 2012;
        }
        if (fach2011.equals("Resultat")) {
            return 2023;
        }
        return -1;
    }

    private boolean isCode(String code2018) {
        Integer value = Integer.valueOf(code2018 = code2018.replaceAll("[\\.,']", ""));
        return value >= 1000;
    }

    public int getCurrentVersion() {
        return Labor2009Tarif.getCurrentCodeVersion();
    }
}

