/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labortarif2009.data;

import ch.elexis.data.LabItem;
import ch.elexis.data.Query;
import ch.elexis.labortarif2009.data.EALBlocksCodeUpdater;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class EALLabItemCodeUpdater {
    public Object updateLabItemCodeAnalysen() {
        int absoluteCnt = 0;
        HashSet<String> problems = new HashSet<String>();
        Query qli = new Query(LabItem.class);
        List items = qli.execute();
        TimeTool today = new TimeTool();
        EALBlocksCodeUpdater.AnalysenUpdateTarifResolver resolver = new EALBlocksCodeUpdater.AnalysenUpdateTarifResolver();
        for (LabItem labItem : items) {
            String code = labItem.getBillingCode();
            if (code == null || code.isEmpty()) continue;
            Labor2009Tarif tarif = (Labor2009Tarif)resolver.getTarif(code, today);
            if (tarif != null) {
                labItem.setBillingCode(tarif.getCode());
                ++absoluteCnt;
                continue;
            }
            problems.add(String.valueOf(labItem.getName()) + " -> " + code);
        }
        ArrayList problemsList = new ArrayList(problems);
        Collections.sort(problemsList);
        StringBuilder problemsString = new StringBuilder();
        for (String string : problemsList) {
            problemsString.append("- ").append(string).append("\n");
        }
        return String.valueOf(absoluteCnt) + " EAL codes in Labor Parametern angepasst.\nIn folgenden Parametern sind noch fehlerhafte Leistungen\n" + problemsString.toString();
    }
}

