/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif_2009.ui.dbcheck;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.statushandlers.StatusManager;

public class AddEAL4708To2013
extends ExternalMaintenance {
    TimeTool startDate = new TimeTool("1.1.2013");
    String errorString;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        IVerrechenbar EAL4708 = this.loadEAL4708();
        if (EAL4708 == null) {
            return this.errorString;
        }
        StringBuilder output = new StringBuilder();
        pm.beginTask("Bitte warten, EAL Zuschalg 4708.00 wird nachgetragen ...", -1);
        int addCount = 0;
        int konsultationCount = 0;
        Query qbe = new Query(Konsultation.class);
        TimeTool tt = new TimeTool(this.startDate.getTimeInMillis());
        qbe.add("Datum", ">=", tt.toString(9));
        List konsultationen = qbe.execute();
        for (Konsultation konsultation : konsultationen) {
            if (konsultation.getRechnung() != null) continue;
            boolean Tarmed0010Found = false;
            boolean EAL4707Found = false;
            boolean EAL4708Found = false;
            List leistungen = konsultation.getLeistungen();
            for (Verrechnet leistung : leistungen) {
                IVerrechenbar verrechenbar = leistung.getVerrechenbar();
                if (verrechenbar.getCodeSystemName().equals("Tarmed") && verrechenbar.getCode().equals("00.0010")) {
                    Tarmed0010Found = true;
                }
                if (verrechenbar.getCodeSystemName().equals("EAL 2009") && verrechenbar.getCode().equals("4707.00")) {
                    EAL4707Found = true;
                }
                if (!verrechenbar.getCodeSystemName().equals("EAL 2009") || !verrechenbar.getCode().equals("4708.00")) continue;
                EAL4708Found = true;
            }
            if (Tarmed0010Found && EAL4707Found && !EAL4708Found) {
                System.out.println("Add to kons " + konsultation.getLabel());
                konsultation.addLeistung(EAL4708);
                ++addCount;
            }
            ++konsultationCount;
        }
        output.append(String.valueOf(konsultationCount) + " offene Konsultationen im Jahr 2013 gefunden.\n");
        output.append(String.valueOf(addCount) + " EAL Zuschlag 4708.00 nachgetragen.\n");
        pm.done();
        return output.toString();
    }

    public IVerrechenbar loadEAL4708() {
        try {
            Query qEntries = new Query(Labor2009Tarif.class);
            qEntries.add("code", "=", "4708.00");
            List entries = qEntries.execute();
            for (Labor2009Tarif labor2009Tarif : entries) {
                if (!labor2009Tarif.isValidOn(this.startDate)) continue;
                return labor2009Tarif;
            }
            this.errorString = "EAL Code 4708.00 nicht gefunden.";
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.base.ch.labortarif_2009", 1, this.errorString, 1);
            StatusManager.getManager().handle((IStatus)status, 2);
            return null;
        }
        catch (NoClassDefFoundError error) {
            this.errorString = "EAL Codesystem nicht gefunden.";
            ElexisStatus status = new ElexisStatus(4, "ch.elexis.base.ch.labortarif_2009", 1, this.errorString, 1);
            StatusManager.getManager().handle((IStatus)status, 2);
            return null;
        }
    }

    public String getMaintenanceDescription() {
        return "EAL Zuschlag 4708.00 in Konsultationen 2013 nachtragen";
    }
}

