/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif_2009.ui;

import ch.elexis.base.ch.labortarif_2009.ui.Labor2009ContentProvider;
import ch.elexis.labortarif2009.data.Labor2009Tarif;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class Labor2009CodeTextValidFilter
extends ViewerFilter {
    private String searchString;
    private TimeTool validDate;
    private Labor2009ContentProvider contentProvider;

    public void setSearchText(String s) {
        this.searchString = s == null || s.length() == 0 ? s : s.toLowerCase();
    }

    public void setValidDate(TimeTool date) {
        this.validDate = date;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Labor2009Tarif tarif = (Labor2009Tarif)((Object)element);
        TarifDescription description = null;
        if (this.contentProvider == null) {
            this.contentProvider = (Labor2009ContentProvider)((StructuredViewer)viewer).getContentProvider();
        }
        if ((description = this.contentProvider.getDescription(tarif)) != null) {
            if (this.validDate != null && !description.isValidOn(this.validDate)) {
                return false;
            }
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            if (description.code != null && description.code.contains(this.searchString)) {
                return true;
            }
            if (description.text != null && description.text.contains(this.searchString)) {
                return true;
            }
        }
        return false;
    }

    protected static class TarifDescription {
        private TimeTool compareTime = new TimeTool();
        private String validFromString;
        private String validToString;
        private String code;
        private String text;

        public TarifDescription(Labor2009Tarif tarif) {
            String[] values = tarif.get(true, new String[]{"GueltigVon", "GueltigBis", "code", "name"});
            this.validFromString = values[0];
            this.validToString = values[1];
            this.code = values[2].toLowerCase();
            this.text = values[3].toLowerCase();
        }

        public boolean isValidOn(TimeTool date) {
            if (this.validFromString != null && this.validFromString.trim().length() > 0) {
                this.compareTime.set(this.validFromString);
                if (this.compareTime.after((Object)date)) {
                    return false;
                }
            }
            if (this.validToString != null && this.validToString.trim().length() > 0) {
                this.compareTime.set(this.validToString);
                if (this.compareTime.before((Object)date) || this.compareTime.equals((Object)date)) {
                    return false;
                }
            }
            return true;
        }
    }
}

