/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking.esr;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.base.ch.ebanking.esr.ESRRecord;
import ch.elexis.base.ch.ebanking.esr.ESRRecordDialog;
import ch.elexis.base.ch.ebanking.esr.ESRSelectionListener;
import ch.elexis.base.ch.ebanking.esr.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.AbstractDataLoaderJob;
import ch.elexis.core.ui.actions.FlatDataLoader;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ESRView2
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.banking.ESRView2";
    private static final String JOB_NAME = "ESR-Loader2";
    private static final int DATUM_INDEX = 0;
    private static final int RN_NUMMER_INDEX = 1;
    private static final int BETRAG_INDEX = 2;
    private static final int EINGELESEN_INDEX = 3;
    private static final int VERRECHNET_INDEX = 4;
    private static final int GUTGESCHRIEBEN_INDEX = 5;
    private static final int PATIENT_INDEX = 6;
    private static final int BUCHUNG_INDEX = 7;
    private static final int DATEI_INDEX = 8;
    private static final String[] COLUMN_TEXTS = new String[]{Messages.ESRView2_date, Messages.ESRView2_billNumber, Messages.ESRView2_amount, Messages.ESRView2_readDate, Messages.ESRView2_accountedDate, Messages.ESRView2_addedDate, Messages.ESRView2_patient, Messages.ESRView2_booking, Messages.ESRView2_file};
    private static final int[] COLUMN_WIDTHS = new int[]{60, 50, 50, 80, 80, 80, 150, 80, 80};
    CommonViewer cv;
    ViewerConfigurer vc;
    FlatDataLoader fdl;
    Query<ESRRecord> qbe;
    private ViewMenus menus;
    private ESRSelectionListener esrl;

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this.getViewSite().getPart());
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.cv = new CommonViewer();
        this.qbe = new Query(ESRRecord.class);
        this.fdl = new FlatDataLoader(this.cv, this.qbe);
        this.fdl.addQueryFilter(new PersistentObjectLoader.QueryFilter(){

            public void apply(Query<? extends PersistentObject> qbe) {
                if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_GLOBAL)) {
                    if (CoreHub.actMandant != null) {
                        qbe.startGroup();
                        qbe.add("MandantID", "=", CoreHub.actMandant.getId());
                        qbe.or();
                        qbe.add("MandantID", "", null);
                        qbe.add("RejectCode", "<>", "0");
                        qbe.endGroup();
                        qbe.and();
                    } else {
                        qbe.insertFalse();
                    }
                }
            }
        });
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)this.fdl, (LabelProvider)new ESRLabelProvider(), (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(this.cv, new String[]{"Datum"}), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 0, this.cv));
        this.cv.create(this.vc, parent, 0, (Object)this.getViewSite());
        this.createColumns(this.cv.getViewerWidget());
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(new IAction[0]);
        this.menus.createMenu(new IAction[0]);
        this.esrl = new ESRSelectionListener();
        this.cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                ESRRecordDialog erd = new ESRRecordDialog(ESRView2.this.getViewSite().getShell(), (ESRRecord)obj);
                if (erd.open() == 0) {
                    cv.notify(CommonViewer.Message.update);
                }
            }
        });
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this.getViewSite().getPart());
    }

    private void createColumns(StructuredViewer viewer) {
        if (!(viewer instanceof TableViewer)) {
            return;
        }
        TableViewer tableViewer = (TableViewer)viewer;
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < COLUMN_TEXTS.length) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(COLUMN_TEXTS[i]);
            column.setWidth(COLUMN_WIDTHS[i]);
            ++i;
        }
    }

    public void setFocus() {
    }

    private void makeActions() {
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        this.esrl.activate(mode);
    }

    class ESRLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        DecimalFormat df = new DecimalFormat("###0.00");

        ESRLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            if (element instanceof ESRRecord) {
                ESRRecord rec = (ESRRecord)((Object)element);
                if (rec.getTyp().equals((Object)ESRRecord.MODE.Summenrecord)) {
                    switch (columnIndex) {
                        case 0: {
                            text = rec.get("Datum");
                            break;
                        }
                        case 1: {
                            text = "Summe";
                            break;
                        }
                        case 2: {
                            text = rec.getBetrag().getAmountAsString();
                            break;
                        }
                        case 8: {
                            text = rec.getFile();
                        }
                    }
                } else {
                    switch (columnIndex) {
                        case 0: {
                            text = rec.get("Datum");
                            break;
                        }
                        case 1: {
                            Rechnung rn = rec.getRechnung();
                            if (rn == null) break;
                            text = rn.getNr();
                            break;
                        }
                        case 2: {
                            text = rec.getBetrag().getAmountAsString();
                            break;
                        }
                        case 3: {
                            text = rec.getEinlesedatatum();
                            break;
                        }
                        case 4: {
                            text = rec.getVerarbeitungsdatum();
                            break;
                        }
                        case 5: {
                            text = rec.getValuta();
                            break;
                        }
                        case 6: {
                            text = rec.getPatient().getLabel();
                            break;
                        }
                        case 7: {
                            String dat = rec.getGebucht();
                            if (StringTool.isNothing((Object)dat)) {
                                text = Messages.ESRView2_notbooked;
                                break;
                            }
                            text = new TimeTool(dat).toString(4);
                            break;
                        }
                        case 8: {
                            text = rec.getFile();
                        }
                    }
                }
            }
            return text;
        }

        public Color getForeground(Object element, int columnIndex) {
            return UiDesk.getColor((String)"schwarz");
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof ESRRecord) {
                ESRRecord rec = (ESRRecord)((Object)element);
                if (rec.getTyp().equals((Object)ESRRecord.MODE.Summenrecord)) {
                    return UiDesk.getColor((String)"gruen");
                }
                String buch = rec.getGebucht();
                if (rec.getRejectCode().equals((Object)ESRRecord.REJECT.OK)) {
                    if (StringTool.isNothing((Object)buch)) {
                        return UiDesk.getColor((String)"grau");
                    }
                    return UiDesk.getColor((String)"weiss");
                }
                return UiDesk.getColor((String)"rot");
            }
            return UiDesk.getColor((String)"himmelblau");
        }
    }

    class ESRLoader
    extends AbstractDataLoaderJob {
        Query<ESRRecord> qbe;

        ESRLoader(Query<ESRRecord> qbe) {
            super(ESRView2.JOB_NAME, qbe, new String[]{"Datum"});
            this.qbe = qbe;
        }

        public IStatus execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ESRView2_loadingESR, 2);
            this.qbe.clear();
            ESRView2.this.vc.getControlFieldProvider().setQuery(this.qbe);
            this.qbe.orderBy(true, new String[]{"Datum", "Gebucht"});
            List list = this.qbe.execute();
            this.result = list.toArray();
            monitor.done();
            return Status.OK_STATUS;
        }

        public int getSize() {
            return PersistentObject.getConnection().queryInt("SELECT COUNT(0) FROM ESRRECORDS");
        }
    }
}

